#ifndef _BALL_H
#define _BALL_H

#include <linux/ioctl.h>

#define BALL_REG_CNT 65536*2

typedef struct {
  unsigned int addr;    /* from 0 to 3 representing x,y,b,r  */
  unsigned int reg_data; /* integer data comes in */
} ball_arg_t;

#define BALL_MAGIC 'q'

/* ioctls and their arguments */
#define BALL_WRITE_REG _IOW(BALL_MAGIC, 1, ball_arg_t *)
#define BALL_READ_REG  _IOWR(BALL_MAGIC, 2, ball_arg_t *)

#endif
