module fit_top( input logic clock, reset,
					input logic [7:0]gen_num,
					input logic  [23:0] color_ram_ping_up,
					input logic [23:0] 	color_ram_ping_down,
					input logic  [23:0] color_ram_pong_up,
					input logic 	[23:0]	color_ram_pong_down,
					input logic   [23:0] color_rom_up,
					input	logic 	[23:0] color_rom_down,
					input logic 	ping,   // decide which ram to compare
					input logic    start,
					
					output logic [15:0] addread_up,
					output logic [15:0] addread_down,
			//		output logic 		  ramselect_1,  // for ping ram read
			//		output logic		  ramselect_2,  // for pong ram read
			//		output logic 		  romselect,
					
					output logic   fit_done,
			
					output logic[39:0]			best,
					output logic[31:0]			diff,
					output logic[7:0]				num);
	
	
	
	logic[31:0]  diff_up, diff_down;
	logic[7:0] 		num_up, num_down;
	logic fit_done_up, fit_done_down;
	logic done, pad;
	fit fit_up(.diff(diff_up),.num(num_up),.addread(addread_up),.fit_done(fit_done_up),.color_ram_ping(color_ram_ping_up),.color_ram_pong(color_ram_pong_up),.color_rom(color_rom_up),.*);
	fit_down fit_down(.diff(diff_down),.num(num_down),.addread(addread_down),.fit_done(fit_done_down),.color_ram_ping(color_ram_ping_down),.color_ram_pong(color_ram_pong_down),.color_rom(color_rom_down),.*);
	
	 always_ff @(posedge clock or posedge reset) begin
		//display of left picture
			if (reset) begin
				best <= 40'hffffffffff;
				diff <= 32'd 0;
				num <= 8'd 0;
				done <= 0 ;
				end
			else if (fit_done_up && fit_done_down && (num_up==num_down))	begin
					diff <= diff_up + diff_down;
					num <= num_up;
					done <=1;
					pad <= 0;
					end
			else if (done == 1) begin
				if (diff < best[31:0]) begin
					best[31:0] <= diff[31:0];
					best[39:31] <= num[7:0];
					pad <=1;
					end
				done <=0;
			end
			else if (num== gen_num-1 && done==0) begin
					best <= 40'hffffffffff;
					diff <= 32'd0;
		end
		end
		
		always_comb begin
			fit_done = fit_done_down && fit_done_up;
		end
			
		endmodule
					