
module evolsmile(input logic        clock,
	       input logic 	  				reset,
	       input logic  [31:0]			writedata,
			 output logic [31:0]			readdata,
			 input logic 					read,
	       input logic 	  				write,
	       input 		  					chipselect,
	       input logic [16:0]  		address,
	       output logic [7:0] 			VGA_R, VGA_G, VGA_B,
	       output logic 	  				VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  				VGA_SYNC_n,
			 output logic [3:0]			LED
			);
	wire			 [15:0]	ping_address_a,ping_address_b;
	wire			 [23:0]	ping_data_a, ping_data_b, ping_q_a ,ping_q_b;
	wire						ping_wren_a,ping_wren_b	;
   ramlisa ram_ping( .clock(clock),
							.address_a(ping_address_a),		//write/read address for drawcircle 
							.data_a(ping_data_a),
							.wren_a(ping_wren_a),
							.q_a(ping_q_a),
							.address_b(ping_address_b),
							.data_b(ping_data_b),
							.wren_b(ping_wren_b),
							.q_b(ping_q_b));
	wire			 [15:0]	left_addr;
	wire			 [23:0]	left_data,left_q;
	reg			 			left_wren;
	ramlisa left_ram( .clock(clock),
							.address_a(left_addr),
							.data_a(left_data),
							.wren_a(left_wren),
							.q_a(left_q),
							.address_b(vga_read_addr),
							.data_b(0),
							.wren_b(0),
							.q_b(color_left));
	wire			 [15:0]	right_addr;
	wire			 [23:0]	right_data,right_q;
	reg			 			right_wren;
	ramlisa right_ram( .clock(clock),
							.address_a(right_addr),
							.data_a(right_data),
							.wren_a(right_wren),
							.q_a(right_q),
							.address_b(vga_read_addr),
							.data_b(0),
							.wren_b(0),
							.q_b(color_right));	
	logic signed [9:0]	xcirc,ycirc;
	logic signed [7:0]	rad;
	logic 		 [23:0] 	opacity;
	logic 		 [23:0] 	color;
	logic 		 			circ_start,circ_ready;
	wire 						circ_write_en_up,circ_write_en_down;
	wire  		 [15:0] 	circ_address_up,circ_address_down;
	wire  		 [23:0] 	circ_color_out_up,circ_color_out_down,circ_color_read_up,circ_color_read_down;
	drawcircle draw ( .*,			
							.xcirc(xcirc),
							.ycirc(ycirc),
							.rad(rad),
							.start(circ_start),
							.ready(circ_ready));

							
	wire  		 [23:0] 	cp_source_data;
	wire  		 [23:0] 	cp_dest_data;
	wire  		 [15:0] 	cp_ram_addr;
	reg 			 			cp_start,cp_ready,cp_write_en;							
	pad		   copy(	.*,
							.source_ram_data(cp_source_data),
							.start(cp_start),
							.ram_addr(cp_ram_addr),
							.write_en(cp_write_en),
							.dest_ram_data(cp_dest_data),
							.ready(cp_ready));
							
	wire  		 [23:0] 	clean_data;
	wire  		 [15:0] 	clean_addr;
	reg 			 			clean_start,clean_ready,clean_write_en;	
	cleanram	  clean( .*,
							.start(clean_start),					
							.clean_addr(clean_addr),
							.write_en(clean_write_en),
							.ready(clean_ready),
							.clean_data(clean_data));
	reg 			 [7:0]	gen_num;
	wire  		 [15:0] 	fit_addr;
	reg						fit_ping,fit_ready,fit_start;
	reg			 [39:0]	fit_best;
	fit  compare_ram( .*,
							.gen_num(gen_num),
							.color_ram_ping(ping_q_a), 
							.color_ram_pong(0), 
							.color_rom(right_q),
							.ping(1),   // decide which ram to compare
							.start(fit_start),					
							.addread(fit_addr),					
							.fit_ready(fit_ready),			
							.best(fit_best));
							
	wire 			 [23:0]  color_left,color_right;
	wire 			 [15:0]  vga_read_addr;
	display	 disp (.*);

	
	typedef enum{s_draw_on_ping,
					 s_clean_ping,
					 s_cp_ping_disp,
					 s_fit_ping,
					 s_write_left,
					 s_write_right,
					 s_write_tmp} state;
	state current_state;
	always_ff @(posedge clock or posedge reset) begin
		if(reset) begin
			current_state<=s_write_right;
			fit_ping<=0;
			gen_num<=200;
			circ_start<=0;
			clean_start<=0;
			cp_start<=0;
			fit_start<=0;
			xcirc<=100;
			ycirc<=100;
			opacity<=24'hffffff;
			color<=24'hff00ff;
			end
		else if(chipselect&&write)
			case(address)
				17'h10000 : gen_num<=writedata[7:0];
				17'h10001 : {xcirc[8:0],ycirc[8:0],rad[6:0]}<=writedata[24:0];
				17'h10002 : opacity<=writedata[23:0];
				17'h10003 : color<=writedata[23:0];
				17'h10004 : current_state<=s_draw_on_ping;
				17'h10005 : current_state<=s_clean_ping;
				17'h10006 : current_state<=s_cp_ping_disp;
				17'h10007 : current_state<=s_fit_ping;
				17'h10008 : current_state<=s_write_left;
				17'h10009 : current_state<=s_write_right;
				17'h1000A : current_state<=s_write_tmp;
			endcase
		else if(chipselect&&read)
			case(address)
				17'h0 : readdata<=fit_best[31:0];
				17'h1 : readdata<=fit_best[39:32];
				17'h2 : readdata[3:0]<={circ_ready,clean_ready,cp_ready,fit_ready};
				17'h3 : circ_start<=1;
				17'h4 : clean_start<=1;
				17'h5 : cp_start<=1;
				17'h6 : fit_start<=1;
			endcase
		else begin
				circ_start<=0;
				clean_start<=0;
				cp_start<=0;
				fit_start<=0;
			end
	end
	always_comb begin		
		case (current_state)
		s_draw_on_ping: begin
			ping_address_a=circ_address_up;
			ping_data_a=circ_color_out_up;
			ping_wren_a=circ_write_en_up;
			
			ping_address_b=circ_address_down;
			ping_data_b=circ_color_out_down;
			ping_wren_b=circ_write_en_down;
						
			left_addr=0;
			left_data=0;
			left_wren=0;
			
			right_addr=0;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=ping_q_a;
			circ_color_read_down=ping_q_b;
			cp_source_data=0;
			LED=0;
			end
		s_clean_ping: begin
			ping_address_a=clean_addr;
			ping_data_a=clean_data;
			ping_wren_a=clean_write_en;
	
			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;
			
			left_addr=0;
			left_data=0;
			left_wren=0;
			
			right_addr=0;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=0;
			LED=1;
			end
		s_cp_ping_disp: begin
			ping_address_a=cp_ram_addr;
			ping_data_a=0;
			ping_wren_a=0;

			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;
			
			left_addr=cp_ram_addr;
			left_data=cp_dest_data;
			left_wren=cp_write_en;
			
			right_addr=0;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=ping_q_a;
			LED=2;
			end
		s_fit_ping: begin
			ping_address_a=fit_addr;
			ping_data_a=0;
			ping_wren_a=0;

			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;
			
			left_addr=0;
			left_data=0;
			left_wren=0;
			
			right_addr=fit_addr;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=0;
			LED=3;
			end
		s_write_left: begin
			ping_address_a=0;
			ping_data_a=0;
			ping_wren_a=0;

			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;

			
			left_addr=address[15:0];
			left_data=writedata[23:0];
			left_wren=write;
			
			right_addr=0;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=0;
			LED=4;
			end
		s_write_right: begin
			ping_address_a=0;
			ping_data_a=0;
			ping_wren_a=0;

			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;
			
			left_addr=0;
			left_data=0;
			left_wren=0;
			
			right_addr=address[15:0];
			right_data=writedata[23:0];
			right_wren=write;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=0;
			LED=5;
			end
		s_write_tmp: begin
			ping_address_a=address[15:0];
			ping_data_a=writedata[23:0];
			ping_wren_a=write;

			ping_address_b=0;
			ping_data_b=0;
			ping_wren_b=0;
			
			left_addr=0;
			left_data=0;
			left_wren=0;
			
			right_addr=0;
			right_data=0;
			right_wren=0;
			
			circ_color_read_up=0;
			circ_color_read_down=0;
			cp_source_data=0;
			LED=5;	
			end
		endcase
	end
endmodule


