//using pipeline methodology
//circle drawing when in mutate function, draw circle when excuting next circle generation untill all circles drawn
//need a bit for ram clear

module drawcircle(input logic        clock,			//should also drive writing port of the ra,
						input logic 	    reset,
						//200*311 need x,y bit width of 9, radius maxium fixed to be 128 7 bits, color 24 bits, opacity 24 bits, 3*24 bits in total
						input logic signed [9:0] xcirc,ycirc,			//one extra for sign
						input logic signed [7:0] rad,
						input logic 		 [23:0] opacity,						//one extra for sign
						input logic 		 [23:0] color,							//color out put
						
						input logic 		 [23:0] circ_color_read_up,
						input logic 		 [23:0] circ_color_read_down,

						input logic 				  start,
						
						
						output logic 		 [23:0] circ_color_out_up,
						output logic 		 [23:0] circ_color_out_down,
						output logic 		 [15:0] circ_address_up,
						output logic 		 [15:0] circ_address_down,
						output logic 				  ready,
						output logic   			  circ_write_en_up,
						output logic 				  circ_write_en_down
						);
/**********************************PARAMETERS*******************************************/
//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;
		wire ready_up,ready_down;
		assign ready=ready_up&ready_down;
		
//updating fsm state		
drawup 	    up(.*, 
					 .circ_color_read(circ_color_read_up),
					 .circ_color_out(circ_color_out_up),
					 .circ_address(circ_address_up),
					 .circ_write_en(circ_write_en_up),
					 .ready(ready_up));
drawdown   down(.*, 
					 .circ_color_read(circ_color_read_down),
					 .circ_color_out(circ_color_out_down),
					 .circ_address(circ_address_down),
					 .circ_write_en(circ_write_en_down),
					 .ready(ready_down));
endmodule
