/**************
*display module for plotting all ram memory data on to the screen
*columbia u 4.4
*/

module display(input logic         clock, reset,
					input logic  [23:0] color_left,
               input	logic  [23:0] color_right,
					
					output logic [15:0] vga_read_addr,
					output logic [7:0]  VGA_R, VGA_G, VGA_B,
					output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
					output logic 	     VGA_SYNC_n);
		
//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;

//position of left picture and right picture
		parameter XL=80;
		parameter XR=360;
		parameter YL=90;
		parameter YR=90;
		
		logic [9:0]  x,y;			
		logic [23:0] color;
		vga_emulator vga(.clk50(clock), .*);

      always_comb begin
		//display of left picture
			if(x>=XL && x<DIMX+XL && y>=YL && y<DIMY+YL) begin
				color=color_left;
				vga_read_addr=(x-XL)*DIMY+(y-YL);
				end
			else if(x>=XR && x<DIMX+XR && y>=YR && y<DIMY+YR) begin
				color=color_right;
				vga_read_addr=(x-XR)*DIMY+(y-YR);
				end
			else begin
				color=24'h00ffff;
				vga_read_addr=16'd0;
			end
		end

endmodule