module cleanram( 	input logic 			clock, reset,
						input logic  			start,
						
						output logic [15:0] 	clean_addr,

						output logic 			write_en,
						output logic   		ready,
						output logic [23:0]	clean_data);

//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;
		
		logic endofram;
		
		typedef enum {s_start,s_clean} state;				//moore
		state current_state, next_state;
		
		logic [15:0] x,nx;
		
		always_ff @(posedge clock or posedge reset) begin
			if (reset) begin
				current_state<=s_start;
				x<=16'd0;
			end
			else begin
				current_state <= next_state;
				x <= nx;
			end
		end
			
			

		always_comb begin
			case(current_state)
			s_start: begin
							if (start)
								next_state = s_clean;							
							else 
								next_state = s_start;
							nx=16'd0;
							ready=1;
						end
			s_clean:	begin
							if(endofram)
								next_state = s_start;
							else
								next_state = s_clean;
							nx=x+1;
							ready=0;
						end 
		endcase
	end
	assign 	write_en=1;
	assign	clean_data=24'd0;
	assign	clean_addr = x;
	assign	endofram = (x==16'd59999);
endmodule