// This module is responsible for comparing the padded picture with the original picture, choose the best one
//implemented by reading fixed number of ramdata from both ram and compare a difference and accumulate with the last row.
//also pipeline methodology, when circles padded, start fitting while next circle is drawing.
module fit( input logic clock, reset,
					input logic [7:0]gen_num,
					input logic  [23:0] color_ram_ping, 
					input logic  [23:0] color_ram_pong, 
					input logic   [23:0] color_rom,
					input logic 	ping,   // decide which ram to compare
					input logic    start,
					
					output logic [15:0] addread,			
					output logic   fit_ready,			
					output logic[39:0]			best);
					
//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;

		logic [31:0] diff;
		logic [9:0]  x=0,y=0;			
		logic  [7:0] num=0;
		logic [31:0] diff_r_ping;
		logic [31:0] diff_g_ping;
		logic [31:0] diff_b_ping;
		logic [31:0] diff_r_pong;
		logic [31:0] diff_g_pong;
		logic [31:0] diff_b_pong;
		logic  fit=0; // indicate the ram can be used to fit
		logic pad;  // indicate the best is found and can be pad to the display ram
		logic [1:0] last=0;
		logic [7:0] num_max;
		logic  count=0;
		
      always_ff @(posedge clock or posedge reset) begin
		//display of left picture
			if (reset) begin
				best <= 40'hffffffffff;
				diff <= 32'd 0;
				x <= 10'd 0;
				y <= 10'd 0;
				num <= 8'd 0;
				fit <= 1'd 0;
				fit_ready <= 1'd 1;
				last <=0;
				count <=0;
				num_max <= 0;
				end
			else if (start) begin
				if (num == num_max) begin
					fit <=1'd 1;
					fit_ready <= 1'd 0;
					diff <= 32'd 0;
					x <= 10'd 0;
					y <=10'd 0;
					last <=0;
					num_max <= gen_num;
					best <= 40'hffffffffff;
					num <= 0;
					count <=0;
					end
				else begin
					fit <=1'd 1;
					fit_ready <= 1'd 0;
					diff <= 32'd 0;
					x <= 10'd 0;
					y <=10'd 0;
					last <=0;
					count<=0;
					num_max <= gen_num;
					end
				
				end
			else if (fit == 1) begin
				if (count ==1) begin
				count <=0;
				if(y== (DIMY-1) && x == (DIMX-1)) begin
					y <= 10'd 0;
					x <= 10'd 0;
					last <=last+1;
				end
				else if (x==0 && y==0 && last==1) begin
					num <= num +8'd 1;//num-1
					fit <= 0;
					fit_ready <= 1'd1;
					last <=0;
					if (diff < best[31:0]) begin
						best[31:0] <= diff;
						best[39:32] <= num;
						pad <=1;
						end
				end
				else if (y == (DIMY-1)) begin
						y <= 10'd 0;
						x <= x + 10'd 1;
					end
				else  begin
						y <= y + 10'd 1;
					end
				end
				if (count==0) begin
					if (ping) diff <= diff + diff_b_ping + diff_g_ping +diff_r_ping;
					else diff <= diff + diff_b_pong + diff_g_pong + diff_r_pong;
					count <=1;
				end
				
				end
		end
			
				
	  always_comb begin			
			addread = x*DIMY + y;
			diff_r_ping = (color_ram_ping[7:0] - color_rom[7:0])*(color_ram_ping[7:0] - color_rom[7:0]);
			diff_g_ping = (color_ram_ping[15:8] - color_rom[15:8])*(color_ram_ping[15:8] - color_rom[15:8]);
			diff_b_ping = (color_ram_ping[23:16] - color_rom[23:16])*(color_ram_ping[23:16] - color_rom[23:16]);
			diff_r_pong = (color_ram_pong[7:0] - color_rom[7:0])*(color_ram_pong[7:0] - color_rom[7:0]);
			diff_g_pong = (color_ram_pong[15:8] - color_rom[15:8])*(color_ram_pong[15:8] - color_rom[15:8]);
			diff_b_pong = (color_ram_pong[23:16] - color_rom[23:16])*(color_ram_pong[23:16] - color_rom[23:16]);			

	  end
endmodule