module pad( 	input logic clock, reset,
					input logic  [23:0] source_ram_data,
					input logic    start,
					
					output logic [15:0] ram_addr,
					output logic write_en,
					output logic [23:0] dest_ram_data,
					output logic   ready);

//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;
		
		logic endofram;
		
		typedef enum {s_start,s_read,s_wait,s_write,s_done} state;				//moore
		state current_state, next_state;
		
		logic signed [15:0] x,nx;
		
		always_ff @(negedge clock or posedge reset) begin
			if (reset) begin
				current_state<=s_start;
				x<=0;
			end
			else begin
				current_state <= next_state;
				x <= nx;
			end
		end
			
			

		always_comb begin
			case(current_state)
			s_start: begin
							if (start)
								next_state = s_read;							
							else 
								next_state = s_start;
							nx=0;;
							ready=1;
							write_en=0;							
						end			  
			s_read:   begin								//just start drawing line, put x,y pos in to states
							next_state = s_wait;
							nx = x;
							ready=0;
							write_en=0;
						end
/////////////////
			s_wait: begin
							next_state=s_write;
							nx=x;
							ready=0;
							write_en=0;
						end
			s_write:	begin
							if(endofram)
								next_state= s_done;
							else
								next_state = s_read;
							nx=x+12'sd1;
							ready=0;	
							write_en=1;
						end				
			s_done:	begin
							next_state = s_start;
							nx=x+1;;
							ready=0;
							write_en=0;
						end					  
		endcase
	end
	assign	endofram = (x==16'd59999);	
	assign 	ram_addr=x;
	assign	dest_ram_data=source_ram_data;
endmodule