//using pipeline methodology
//circle drawing when in mutate function, draw circle when excuting next circle generation untill all circles drawn
//need a bit for ram clear

module drawcircle(input logic        clock,			//should also drive writing port of the ra,
						input logic 	    reset,
						//200*311 need x,y bit width of 9, radius maxium fixed to be 128 7 bits, color 24 bits, opacity 24 bits, 3*24 bits in total
						input logic signed [9:0] xcirc,ycirc,			//one extra for sign
						input logic signed [7:0] rad,
						input logic 		 [23:0] opacity,						//one extra for sign
						input logic 		 [23:0] color,							//color out put
						
						input logic 		 [23:0] circ_color_read,
						input logic 				  start,
						
						
						output logic 		 [23:0] circ_color_out,
						output logic 		 [15:0] circ_address,
						output logic 				  ready,
						output logic   			  circ_write_en
						);
/**********************************PARAMETERS*******************************************/
//dimention of every single block of picture to display, maxium dim to be 65535		
		parameter DIMX=200;
		parameter DIMY=300;
/**********************************FLAGS***********************************************/
		logic endofline,endofcirc,incirc,valid;
/**********************************STATES************************************************/
		typedef enum {s_start,s_sol,s_molr,s_molw,s_eol,s_done,s_molr2,s_molw2} state_circle;				//moore
		state_circle current_state, next_state;
/**********************************BUFFERS************************************************/
		logic signed [11:0] x, y, nx, ny;
		logic [12:0] xbuff,ybuff;
		logic [20:0] xsquare,ysquare,rsquare;
		
		logic [32:0] r_temp,g_temp,b_temp;
		logic [7:0]  r_new,g_new,b_new;
		
//updating fsm state		
		always_ff @(negedge clock or posedge reset) begin
			if(reset) begin
				current_state<=s_start;
				x<=-12'sd1;
				y<=-12'sd1;
			end
			else begin
				current_state<=next_state;
				x<=nx;
				y<=ny;
			end
		end
		

//comb logic for next state
//algorithm for drawing a circle is scanning the pixels in evenlope square of the circle, using x^2+y^2<r^2



		always_comb begin
			case(current_state)
			s_start: begin
							if (start)
								next_state = s_sol;							
							else 
								next_state = s_start;
							nx=-12'sd1;
							ny=-12'sd1;
							circ_write_en=0;				
						   ready=1;
						end
			  
			s_sol:   begin								//just start drawing line, put x,y pos in to states
							next_state = s_molr;
							nx = xcirc-rad;
							ny = ycirc-rad;
							circ_write_en=0;
							ready=0;
						end
			
			s_molr:	begin
							next_state = s_molr2;//s_molw;
							nx=x;
							ny=y;
							circ_write_en=0;
							ready=0;
						end
/////////////////
			s_molr2: begin
							next_state=s_molw;
							nx=x;
							ny=y;
							circ_write_en=0;
							ready=0;
						end
			s_molw: begin
							next_state=s_molw2;
							nx=x;
							ny=y;
							circ_write_en=0;
							ready=0;
						end
			s_molw2:	begin
							if(endofline)
								next_state= s_eol;
							else
								next_state = s_molr;
							nx=x+12'sd1;
							ny=y;
							ready=0;
							circ_write_en=(valid && incirc);
						end				
			s_eol: 	begin
							if (endofcirc) begin
								next_state = s_done;
								nx=-12'sd1;
								ny=-12'sd1;
								end
							else begin
								next_state = s_molr;
								nx=xcirc-rad;
								ny=y+12'sd1;
								end
							ready=0;
							circ_write_en=0;
						end
			s_done:	begin
							next_state = s_start;
							nx=-12'sd1;
							ny=-12'sd1;
							ready=0;
							circ_write_en=0;
						end					  
		endcase
	end

	always_comb	begin
		//address,circ_color_out
		//writing region valid, which in the image we are wirting
		valid=(x>=0 && y>=0 && x<DIMX && y<DIMY);
		//next_valid=(nx>=0 && ny>=0 && nx<DIMX && ny<DIMY);
		if(valid)
			circ_address=(x*DIMY+y);
		else
			circ_address=16'd0;
		endofline = (x>=xcirc+rad);
	   endofcirc = (y>=ycirc+rad);
		//incircle judgement
		rsquare=rad*rad;
		xbuff=x<xcirc? (xcirc-x):(x-xcirc);
		ybuff=y<ycirc? (ycirc-y):(y-ycirc);
		xsquare=xbuff*xbuff;
		ysquare=ybuff*ybuff;
		incirc=(xsquare+ysquare<rsquare);
		
		//overlapping
		r_temp=(color[23:16]*opacity+circ_color_read[23:16]*(24'hffffff-opacity))>>24;
		g_temp=(color[15:8]*opacity+circ_color_read[15:8]*(24'hffffff-opacity))>>24;
		b_temp=(color[7:0]*opacity+circ_color_read[7:0]*(24'hffffff-opacity))>>24;
		if(r_temp>255) 
			r_new=8'hff;
		else	
			r_new=r_temp[7:0];
			
		if(g_temp>255) 
			g_new=8'hff;
		else	
			g_new=g_temp[7:0];
			
		if(b_temp>255) 
			b_new=8'hff;
		else	
			b_new=b_temp[7:0];
		
		circ_color_out={r_new,g_new,b_new};
	end
endmodule
