#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

#define VGA_LED_DIGITS 8

typedef struct {
  unsigned char digit;    /* 0, 1, .. , VGA_LED_DIGITS - 1 */
  unsigned char segments; /* LSB is segment a, MSB is decimal point */
} vga_led_arg_t;

//HEEEEEEREEEEE
typedef struct {
	unsigned int price;
	unsigned int address;
	unsigned int change_check;
	unsigned int display;
	unsigned int we;
} stock_market;
//HEEEERRREEE

typedef struct {
	unsigned int print_bit;
	unsigned int stock_id;
	unsigned int graph_id;
	unsigned int x_graph;
	unsigned int y_graph;
} stock_disp_struct;

typedef struct {
	unsigned int write_read;
	unsigned int stock_id;
	unsigned int data; //either stock value or time!!
} final_stock;



#define VGA_LED_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_LED_WRITE_DIGIT _IOW(VGA_LED_MAGIC, 1, vga_led_arg_t *)
#define VGA_LED_READ_DIGIT  _IOWR(VGA_LED_MAGIC, 2, vga_led_arg_t *)
#define VGA_LED_STOCK_MARKET _IOW(VGA_LED_MAGIC, 3, vga_led_arg_t *)
#define VGA_LED_STOCK_DISP _IOW(VGA_LED_MAGIC, 4, vga_led_arg_t *)
#define VGA_LED_FINAL_STOCK _IOW(VGA_LED_MAGIC, 5, vga_led_arg_t *)

#endif

