/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include <stdlib.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <pthread.h>

int vga_led_fd;
int shared_stock_id;
int restart;
int hard_range;
pthread_t ReadUser;
void *ReadUser_f(void *);

void disp_final(unsigned int write_read, unsigned int stock_id, unsigned int data)
{
	final_stock fs;
	fs.write_read = write_read;
	fs.stock_id = stock_id;
	fs.data = data;

	if(ioctl(vga_led_fd, VGA_LED_FINAL_STOCK, &fs)) {
		perror("ioctl(VGA_LED_STOCK_DISP) failed");
	}

}

int main()
{

	//------------------------------------

	  vga_led_arg_t vla;
  int i = 0;
	int z = 0;
  int x;
	int y;

	int line_num = 0;
	char *p;
	char *token[5];
	int m = 0;

  int radius=3;
  int no_zero = 0;
	double temp;
	int temp1;
  int last_line;
  double stock[30000];


	char line [64];
	static const char filename[] = "/dev/vga_led";

  FILE *fp;
  fp = fopen("data.txt", "r");
	//printf("%f", atof("\n"));
  if ( fp != NULL ) 
	{
  	//printf("The data file has been opened successfully! \n");

  	while(fgets(line, sizeof(line), fp) != NULL)
  	{
    	//printf("Read in one line! \n");

			m = 0;
			line_num = line_num + 1;
			//printf("The line: %s\n", line);

				//printf("A\n");
				p = strtok(line, " ");
				while(p != NULL)
				{
					//printf("B\n");
					token[m++] = p;
					p = strtok(NULL, " ");
					//printf("C\n");
				}
				//printf("D\n");
				//printf("The token[1]: %s\n", token[1]);
				stock[z] = atof(token[1]);
				temp1 = (int)(stock[z]);
				//printf("Temp1: %d\n", temp1);
				if(no_zero == 0 && temp1 == 0)
				{
					last_line = z;
					no_zero = 1;
					printf("Last Line: %d\n", last_line);
				}
				//printf("The value saved: %f\n", stock[z]);
				//printf("E\n");
				//avg1[z] = atof(token[2]);
				//avg2[z] = atof(token[3]);
				//avg3[z] = atof(token[4]);
				z = z + 1;

			//printf("C\n");
			//stock[i] = atof(line);
			//last_line = i;
			i = i + 1;
  	}

	}
	last_line = z;
	//printf("Z: %d\n", last_line); 
  fclose(fp);

	//printf("Stock 0: %f\n", stock[0]);
	//printf("Stock 1: %f\n", stock[1]);
	
	//for number of stocks!

	int min0; 
	int max0;
	int min1; 
	int max1;
	int min2; 
	int max2;
	int min3;
	int max3;
	int min4;
	int max4;
	int min5;
	int max5;
	int min6;
	int max6;
	int range[6];

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

	min0 = stock[0];
	max0 = stock[0];
	min1 = stock[1];
	max1 = stock[1];
	min2 = stock[2];
	max2 = stock[2];
	min3 = stock[3];
	max3 = stock[3];
	min4 = stock[4];
	max4 = stock[4];
	min5 = stock[5];
	max5 = stock[5];
	min6 = stock[6];
	max6 = stock[6];

	i = 0;
	while (i < last_line)
	{
		if (i%7 == 0)
		{
			if (stock[i] > max0)
			{
	
				max0 = stock[i];
			}
			if (stock[i] < min0)
			{
				min0 = stock[i];
			}
		}
		if (i%7 == 1)
		{
			if (stock[i] > max1)
			{
				max1 = stock[i];
			}
			if (stock[i] < min1)
			{
				min1 = stock[i];
			}
		}		
		if (i%7 == 2)
		{
			if (stock[i] > max2)
			{
				max2 = stock[i];
			}
			if (stock[i] < min2)
			{
				min2 = stock[i];
			}
		}
		if (i%7 == 3)
		{
			if (stock[i] > max3)
			{
				max3 = stock[i];
			}
			if (stock[i] < min3)
			{
				min3 = stock[i];
			}
		}
		if (i%7 == 4)
		{
			if (stock[i] > max4)
			{
				max4 = stock[i];
			}
			if (stock[i] < min4)
			{
				min4 = stock[i];
			}
		}
		if (i%7 == 5)
		{
			if (stock[i] > max5)
			{
				max5 = stock[i];
			}
			if (stock[i] < min5)
			{
				min5 = stock[i];
			}
		}
		if (i%7 == 6)
		{
			if (stock[i] > max6)
			{
				max6 = stock[i];
			}
			if (stock[i] < min6)
			{
				min6 = stock[i];
			}
		}
		i = i + 1;

	}

	range[0] = max0 - min0;
	range[1] = max1 - min1;
	range[2] = max2 - min2;
	range[3] = max3 - min3;
	range[4] = max4 - min4;
	range[5] = max5 - min5;
	range[6] = max6 - min6;
	//printf("Max: %d\n", max0);
	//printf("Min: %d\n", min0);
	//printf("Range: %d\n", range[0]); 	
	int test = (int)(range[0]/2) + 65536;

	//printf("Test data: %d\n", test);
	



	i = 0;

	int j = 0;	
	//FINAL STUFF
	int write_read = 0;
	int stock_id = 0;
	int data = 0;


	pthread_create(&ReadUser, NULL, ReadUser_f, NULL);


	while (1)
	{
			i = 0;
			j = 0;
			while (i < last_line)
			{
				if (restart == 1)
				{
					restart = 0;
					i = 0;
					j = 0;
					while (j < 401)
					{
						data = 0;
						write_read = 0;
						stock_id = 0;
					  disp_final(write_read, stock_id, data);
						stock_id = 1;
					  disp_final(write_read, stock_id, data);
						stock_id = 2;
					  disp_final(write_read, stock_id, data);
						stock_id = 3;
					  disp_final(write_read, stock_id, data);
						stock_id = 4;
					  disp_final(write_read, stock_id, data);
						stock_id = 5;
					  disp_final(write_read, stock_id, data);
						stock_id = 6;
					  disp_final(write_read, stock_id, data);
				
						j = j + 1;
					}	
				}	

				if (i%7 == 0)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 0;
					disp_final(write_read, stock_id, data);
					//send, then wait shortly
					usleep(1000);
				}
				if (i%7 == 1)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 1;
					disp_final(write_read, stock_id, data);
					usleep(1000);
				}
				if (i%7 == 2)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 2;
					disp_final(write_read, stock_id, data);
					usleep(1000);
				}
				if (i%7 == 3)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 3;
					disp_final(write_read, stock_id, data);
					usleep(1000);
				}
				if (i%7 == 4)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 4;
					disp_final(write_read, stock_id, data);
					usleep(1000);
				}
				if (i%7 == 5)
				{
					data = stock[i];
					write_read = 0;
					stock_id = 5;
					disp_final(write_read, stock_id, data);
					usleep(1000);
				}

				if (i%7 == 6)
				{	
					data = stock[i];
					write_read = 0;
					stock_id = 6;
					disp_final(write_read, stock_id, data);
					usleep(1000);

					stock_id = shared_stock_id;
					if (hard_range == 0)
					{
						data = 0;
					}					
					if (hard_range == 1)
					{
						data = range[stock_id]/2 + 65536;
					}
					write_read = 1;
					disp_final(write_read, stock_id, data);
					usleep(65000);
				}
				

				i = i + 1;
			}
	}





  //printf("VGA LED Userspace program terminating\n");
	pthread_exit(NULL);
  return 0;
}



void *ReadUser_f(void *ignored)
{

	char usr_input [10];
	char IBM[] = "IBM";
	char TEVA[] = "TEVA";
	char INTC[] = "INTC";
	char ED[] = "ED";
	char KO[] = "KO";
	char DBD[] = "DBD";
	char PG[] = "PG";
	char Restart[] = "Restart";
	char Fix_Range[] = "Fix";
	char Flex_Range[] = "Flex";
	printf ("The stocks being tracked are: IBM, TEVA, INTC, ED, KO, DBD, and PG. \n");
	restart = 1;
	while (1)
  {
		printf ("Enter stock name or command: ");
		scanf ("%s", usr_input);
		if (strcmp(usr_input, IBM) == 0)
		{
			shared_stock_id = 0;
		}
		if (strcmp(usr_input, TEVA) == 0)
		{
			shared_stock_id = 1;
		}
		if (strcmp(usr_input, INTC) == 0)
		{
			shared_stock_id = 2;
		}
		if (strcmp(usr_input, ED) == 0)
		{
			shared_stock_id = 3;
		}
		if (strcmp(usr_input, KO) == 0)
		{
			shared_stock_id = 4;
		}
		if (strcmp(usr_input, DBD) == 0)
		{
			shared_stock_id = 5;
		}
		if (strcmp(usr_input, PG) == 0)
		{
			shared_stock_id = 6;
		}
		if (strcmp(usr_input, Restart) == 0)
		{
			restart = 1;
		}
		if (strcmp(usr_input, Fix_Range) == 0)
		{
			hard_range = 1;
		}
		if (strcmp(usr_input, Flex_Range) == 0)
		{
			hard_range = 0;
		}
	}
	pthread_exit(NULL);
}




















	//END



/*
	int temp_coord;
	int times_through = 0;
	double adjust_value;
	double min = stock[0];
	double max = stock[0];
	double range;
	i = 0;
	//need to adjust for max and min and scale appropriately


	int price; 
	int time;
	int address = 0; //from 0 to 31
	int change_check = 0; //1 bit
	int display = 0; // 1 bit
	int we; //1 bit

	//for milestone 3
	int send_value[300];

*/

/*
	i = 0;
	while (i < 300)
	{
		send_value[i] = -1;
		i = i + 1;
	} 
	i = 0;
*/
/*
/*
	while(1)
	{
	/*
		print_bit = 1;
		x_graph = 200;
		y_graph = 200;
		disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);
		i = 100000;
		usleep(1000000); 

		i = 0;

		while(i < 650)
		{
			print_bit = 1;
			graph_id = 0;
			x_graph = i;
			y_graph = 700;
			disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);

			print_bit = 1;
			graph_id = 1;
			x_graph = i;
			y_graph = 700;
			disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);

			print_bit = 1;
			graph_id = 2;
			x_graph = i;
			y_graph = 700;
			disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);

			print_bit = 1;
			graph_id = 3;
			x_graph = i;
			y_graph = 700;
			disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);
			i = i + 1;
		}
		i = 0;
		while(i<last_line)
		{			
			if (i < 400)
			{			
				graph_id = 0;
				send_value[i] = (int) (400 - (stock[i] - min)*300/range);  
				print_bit = 1;
				x_graph = i + 100;
				y_graph = send_value[i];
				disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);
			
				graph_id = 1;
				send_value[i] = (int) (400 - (avg1[i] - min)*300/range);  
				print_bit = 1;
				x_graph = i + 100;
				y_graph = send_value[i] + 5;
				disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);

				graph_id = 2;
				send_value[i] = (int) (400 - (avg2[i] - min)*300/range);  
				print_bit = 1;
				x_graph = i + 100;
				y_graph = send_value[i] + 10;
				disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);

				graph_id = 3;
				send_value[i] = (int) (400 - (avg3[i] - min)*300/range);  
				print_bit = 1;
				x_graph = i + 100;
				y_graph = send_value[i] + 15;
				disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);



				usleep(30000); 
			}	
			if (i >= 400)
			{
				j = 0;
				while(j < 400)
				{
					graph_id = 0;
					send_value[j] = (int) (400 - (stock[j+(i-399)] - min)*300/range); 
					x_graph = j + 100;
					y_graph = send_value[j];
					disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph); 

					graph_id = 1;
					send_value[j] = (int) (400 - (avg1[j+(i-399)] - min)*300/range); 
					x_graph = j + 100;
					y_graph = send_value[j];
					disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph); 

					graph_id = 2;
					send_value[j] = (int) (400 - (avg2[j+(i-399)] - min)*300/range); 
					x_graph = j + 100;
					y_graph = send_value[j];
					disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph); 

					graph_id = 3;
					send_value[j] = (int) (400 - (avg3[j+(i-399)] - min)*300/range); 
					x_graph = j + 100;
					y_graph = send_value[j];
					disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph); 
					j = j + 1;
				}	
				usleep(30000);	
			}
			i = i + 1;	
				/*
				j = 0;
				print_bit = 1;
				while (j < i)
				{
					//send values, last send has write okay flag
					x_graph = j + 100;
					y_graph = send_value[j];
					printf("Print bit: %d\n", print_bit);
					printf("stock_id: %d\n", stock_id);
					printf("graph_id: %d\n", graph_id);
					printf("x_graph: %d\n", x_graph);
					printf("y_graph: %d\n", y_graph);
					usleep(100000); 
					disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);
					j = j + 1;
				}
				x_graph = i + 100;
				y_graph = send_value[i];
				print_bit = 1;
					printf("Print bit: %d\n", print_bit);
					printf("stock_id: %d\n", stock_id);
					printf("graph_id: %d\n", graph_id);
					printf("x_graph: %d\n", x_graph);
					printf("y_graph: %d\n", y_graph);
					usleep(100000); 
				disp_stock(print_bit, stock_id, graph_id, x_graph, y_graph);
			

		}

	}









	while(1)
	{
		printf("Please, enter a stock price: ");
		scanf("%d", &price);
		printf("w/e bit: ");
		scanf("%d", &we);
		printf("Please, enter an address: "); // from 0 to 31
		scanf("%d", &address);
		write_stock(price, address, change_check, display, we);



	}



/*
		while(1)
	{
		printf("Please enter a x_mem: ");
		scanf("%d", &x_mem);
		printf("Please enter a y_mem: ");
		scanf("%d", &y_mem);
		printf("Please enter an address: ");
		scanf("%d", &address);
		printf("Please enter a w/e: ");
		scanf("%d", &we);
		make_address(x_mem, y_mem, address, we, message);
		printf("Message: %d\n", message[0]);
		write_segments(message);
	}
*/






/*
	i = 0;
	while (i < last_line)
	{

		
    adjust_value = (stock[i] - min)*200/range + 100;
		y = (int) adjust_value;

  	   
		x = i - 640*times_through;
    temp_coord = x;
		x = y;
		y = temp_coord;
		make_coord(x, y,radius, message);
		write_segments(message);
		usleep(10000);
		i = i + 1;
		if (y >= 640)
		{
			times_through = times_through + 1;
		}
  
	}

*/












/*
int main()
{
  vga_led_arg_t vla;
  int i;
  int x;
	int y;
	int vx;
	int vy;
  int radius;

  static const char filename[] = "/dev/vga_led";

  static unsigned char message[8] = { 200, 0x00, 200, 0x00,
				      0x00, 0x00, 0x00, 0x00 };



  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }


	printf("\n");
	printf("The radius must be between 1 and 200. The starting coordinates must be chosen such that x - radius is positive and y - radius is positive. The velocity can be negative. Since it corresponds to how many pixels are travelled in an iteration, too large of a velocity will look choppy.\n");
	printf("\n");
	printf("Please enter a starting x coordinate: ");
	scanf("%d", &y);
	printf("Please enter a starting y coordinate: ");
	scanf("%d", &x);
	printf("Please enter a starting x velocity: ");
	scanf("%d", &vy);
	printf("Please enter a starting y velocity: ");
	scanf("%d", &vx);
	printf("Please the radius of the ball: ");
	scanf("%d", &radius);




	while (1)
	{
		//ints only!
		x = x + vx;
		y = y + vy;
		//boundary conditions
		if (y >= 640 - radius)
		{
			vy = -vy;
		}
		if (y <= 0 + radius)
		{
			vy = -vy;
		}
		if (x >= 480 - radius)
		{
			vx = -vx;
		}
		if (x <= 0 + radius)
		{
			vx = -vx;
		}
		make_coord(x, y,radius, message);
		write_segments(message);
		//sleep
		usleep(10000);
	}

  printf("VGA LED Userspace program terminating\n");

  return 0;
}

*/

  

    

/*
	printf("\n");
	printf("The radius must be between 1 and 200. The starting coordinates must be chosen such that x - radius is positive and y - radius is positive. The velocity can be negative. Since it corresponds to how many pixels are travelled in an iteration, too large of a velocity will look choppy.\n");
	printf("\n");
	printf("Please enter a starting x coordinate: ");
	scanf("%d", &y);
	printf("Please enter a starting y coordinate: ");
	scanf("%d", &x);
	printf("Please enter a starting x velocity: ");
	scanf("%d", &vy);
	printf("Please enter a starting y velocity: ");
	scanf("%d", &vx);
	printf("Please the radius of the ball: ");
	scanf("%d", &radius);
*/

    /*
		x = x + vx;
		y = y + vy;
		if (y >= 640 - radius)
		{
			vy = -vy;
		}
		if (y <= 0 + radius)
		{
			vy = -vy;
		}
		if (x >= 480 - radius)
		{
			vx = -vx;
		}
		if (x <= 0 + radius)
		{
			vx = -vx;
		}
    */
    
/*
Read and print the segment values
void print_segment_info() {
  vga_led_arg_t vla;
  int i;

  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_READ_DIGIT) failed");
      return;
    }
    printf("%02x ", vla.segments);
  }
  printf("\n");
}

 Write the contents of the array to the display 
void write_segments(const unsigned char segs[8])
{
  vga_led_arg_t vla;
  int i;
  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    vla.segments = segs[i];
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }
}


void make_coord(int x, int y, int radius,char message[])
{
	//printf("%d\n", x);
	//printf("%d\n", y);
	message[1] = (char) (y/256);
	message[0] = (char) y%256;
	message[3] = (char) (x/256);
	message[2] = (char) x%256;
	message[4] = radius;
	message[5] = 100;
	message[6] = 100;
  message[7] = 100;

}

void make_address(int x_mem, int y_mem, int address, int we, char message[])
{
	int sender = 0;
	if (we == 1)
	{
		sender = sender + 128;
	}
	printf("Sender: %d\n", sender);
	sender = sender + address*16;
	printf("Sender: %d\n", sender);
	sender = sender + x_mem*4;
	printf("Sender: %d\n", sender);
	sender = sender + y_mem;
	printf("Sender: %d\n", sender);
	message[0] = (char) sender;
	message[1] = (char) sender;
	message[2] = (char) sender;
	message[3] = (char) sender;
	message[4] = (char) sender;
	message[5] = (char) sender;
	message[6] = (char) sender;
	message[7] = (char) sender;
}

void write_stock(unsigned int price, unsigned int address, unsigned int change_check, unsigned int display, unsigned int we)
{
	stock_market sm;
	sm.price = price;
	sm.address = address;
	sm.change_check = change_check;
	sm.display = display;
	sm.we = we;

	if(ioctl(vga_led_fd, VGA_LED_STOCK_MARKET, &sm)) {
		perror("ioctl(VGA_LED_STOCK_MARKET) failed");
		return;
	}

}

void disp_stock(unsigned int print_bit, unsigned int stock_id, unsigned int graph_id, unsigned int x_graph, unsigned int y_graph)
{
	stock_disp_struct sd;
	sd.print_bit = print_bit;
	sd.stock_id = stock_id;
	sd.graph_id = graph_id;
	sd.x_graph = x_graph;
	sd.y_graph = y_graph;

	if(ioctl(vga_led_fd, VGA_LED_STOCK_DISP, &sd)) {
		perror("ioctl(VGA_LED_STOCK_DISP) failed");
	}

}
*/




