

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [31:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [2:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);

			 
			 
   logic [9:0] x_coord, y_coord_in, y_coord_out, y_coord;
	logic [1:0] x_code, y_code;
	logic [9:0] radius;
	logic [31:0] display;
	logic [19:0] new_stock, stored_stock;
	logic [4:0] stock_address;
	logic [24:0] sum32;
	logic [5:0] sum_state;
	logic change_check;
	logic display_choice;
	//-----------------------------------------
	logic [9:0] disp_stock_x [399:0];
	logic [9:0] disp_stock_a1 [399:0];
	logic [9:0] disp_stock_a2 [399:0];
	logic [9:0] disp_stock_a3 [399:0];
	logic send_to_vga;
	logic [6:0] stock_name;
	//-----------------------------------------

		logic [16:0] ema4_out;
	logic [16:0] ema32_out;
	logic [16:0] ema128_out;
	logic [16:0] disp_stock [19:0]; //19 for the number of stock modules...
	logic [16:0] disp_avg4 [19:0];
   logic [16:0] disp_avg32 [19:0];
   logic [16:0] disp_avg128 [19:0];
	
	logic [16:0] final_dispS [399:0];
	logic [16:0] final_dispA4 [399:0];
	logic [16:0] final_dispA32 [399:0];
	logic [16:0] final_dispA128 [399:0];
	logic [16:0] fd1;
	logic [16:0] fd2;
	logic [16:0] fd3;
	logic [16:0] fd4;
	logic [8:0] in_ind;
	
	logic [8:0] out_ind;
	logic [9:0] sd1;
	logic [9:0] sd2;
	logic [9:0] sd3;
	logic [9:0] sd4;	
	logic [9:0] scale_dispS [399:0];
	logic [9:0] scale_dispA4 [399:0];
	logic [9:0] scale_dispA32 [399:0];
	logic [9:0] scale_dispA128 [399:0];
 	
	logic [16:0] fake1;
	logic [16:0] fake2;
	logic [16:0] fake3;
	logic [16:0] fake4;
	
	logic update_done[19:0];
	logic update_begin[19:0];
	logic last_update_done[19:0];
	logic last_update_begin[19:0];
	logic begin_ranger;
	
	logic start_flag;
	logic end_flag;
	logic [8:0] output_index;
	
	logic [15:0] sum64_out;
	
	logic [16:0] data_send [19:0]; //number of stock modules
 
	logic [9:0] counter_top;
	logic [9:0] counter_delay;
	logic [19:0] disp_delay;
	logic change_flag [19:0]; //number of stock modules
	logic request_disp [19:0];
	logic new_disp [19:0];
	logic [8:0] output_id;
	logic [8:0] debug1;
	logic [16:0] debug2;
	logic [16:0] min;
	logic [16:0] divide_min;
	logic [16:0] max;
	logic done_range;
	
	logic scale_output;
	logic [16:0] range;
	logic [16:0] hard_range;
	logic hard_range_flag;

	//
	logic [1:0] bhs;
	//--------------------- 
	logic read_soft;
	logic write_soft;
	// flags for hang
	logic hang_start;
	logic [1:0] hang_count;
	//	
	// have conversions to decimal
	logic [3:0] S_hundredthousand;
	logic [3:0] S_tenthousand;
	logic [3:0] S_thousand;
	logic [3:0] S_hundred;
	logic [3:0] S_ten;
	logic [3:0] S_one;

	logic [3:0] E4_hundredthousand;
	logic [3:0] E4_tenthousand;
	logic [3:0] E4_thousand;
	logic [3:0] E4_hundred;
	logic [3:0] E4_ten;
	logic [3:0] E4_one;
	
	logic [3:0] E32_hundredthousand;
	logic [3:0] E32_tenthousand;
	logic [3:0] E32_thousand;
	logic [3:0] E32_hundred;
	logic [3:0] E32_ten;
	logic [3:0] E32_one;
	
	logic [3:0] E128_hundredthousand;
	logic [3:0] E128_tenthousand;
	logic [3:0] E128_thousand;
	logic [3:0] E128_hundred;
	logic [3:0] E128_ten;
	logic [3:0] E128_one;
	
	logic start_dec;

//--------------------------------------------

	logic [16:0] low_disp;
	logic [16:0] high_disp;
	logic [16:0] adj_range;

		
	//have hook up to module here
	
	
	
	
	divider dv_instance(
		.clk(clk),
		.range(range),
		.min(divide_min),
		.input_val1(fd1),
		.input_val2(fd2),
		.input_val3(fd3),
		.input_val4(fd4),
		.input_index(in_ind),
		.output_val1(sd1),
		.output_val2(sd2),
		.output_val3(sd3),
		.output_val4(sd4),
		.adj_range(adj_range),
		.output_index(out_ind)
	);
	
	nothing_master nm_instance(
		.clk(clk),
		.debug1(debug1),
		.begin_ranger(begin_ranger),
		.debug2(debug2),
		.disp1(fake1),
		.disp2(fake2), 
		.disp3(fake3),
		.disp4(fake4),
		.done_range(done_range),
		.max(max),
		.min(min)
	);
	
	
	stock_master sm_instance0(
			.clk(clk),
			.stock_in(data_send[0]),
			.update_begin(update_begin[0]),
			.update_done(update_done[0]),
			.request_disp(request_disp[0]),
			.new_disp(new_disp[0]),
			.disp_stock(disp_stock[0]),
			.disp_avg4(disp_avg4[0]),
			.disp_avg32(disp_avg32[0]),
			.disp_avg128(disp_avg128[0]),
			.change_flag(change_flag[0])
	);
	
		stock_master sm_instance1(
			.clk(clk),
			.stock_in(data_send[1]),
			.update_begin(update_begin[1]),
			.update_done(update_done[1]),
			.request_disp(request_disp[1]),
			.new_disp(new_disp[1]),
			.disp_stock(disp_stock[1]),
			.disp_avg4(disp_avg4[1]),
			.disp_avg32(disp_avg32[1]),
			.disp_avg128(disp_avg128[1]),
			.change_flag(change_flag[1])
	);
	
		stock_master sm_instance2(
			.clk(clk),
			.stock_in(data_send[2]),
			.update_begin(update_begin[2]),
			.update_done(update_done[2]),
			.request_disp(request_disp[2]),
			.new_disp(new_disp[2]),
			.disp_stock(disp_stock[2]),
			.disp_avg4(disp_avg4[2]),
			.disp_avg32(disp_avg32[2]),
			.disp_avg128(disp_avg128[2]),
			.change_flag(change_flag[2])
	);
	
		stock_master sm_instance3(
			.clk(clk),
			.stock_in(data_send[3]),
			.update_begin(update_begin[3]),
			.update_done(update_done[3]),
			.request_disp(request_disp[3]),
			.new_disp(new_disp[3]),
			.disp_stock(disp_stock[3]),
			.disp_avg4(disp_avg4[3]),
			.disp_avg32(disp_avg32[3]),
			.disp_avg128(disp_avg128[3]),
			.change_flag(change_flag[3])
	);
	
		stock_master sm_instance4(
			.clk(clk),
			.stock_in(data_send[4]),
			.update_begin(update_begin[4]),
			.update_done(update_done[4]),
			.request_disp(request_disp[4]),
			.new_disp(new_disp[4]),
			.disp_stock(disp_stock[4]),
			.disp_avg4(disp_avg4[4]),
			.disp_avg32(disp_avg32[4]),
			.disp_avg128(disp_avg128[4]),
			.change_flag(change_flag[4])
	);
	
		stock_master sm_instance5(
			.clk(clk),
			.stock_in(data_send[5]),
			.update_begin(update_begin[5]),
			.update_done(update_done[5]),
			.request_disp(request_disp[5]),
			.new_disp(new_disp[5]),
			.disp_stock(disp_stock[5]),
			.disp_avg4(disp_avg4[5]),
			.disp_avg32(disp_avg32[5]),
			.disp_avg128(disp_avg128[5]),
			.change_flag(change_flag[5])
	);
	
		stock_master sm_instance6(
			.clk(clk),
			.stock_in(data_send[6]),
			.update_begin(update_begin[6]),
			.update_done(update_done[6]),
			.request_disp(request_disp[6]),
			.new_disp(new_disp[6]),
			.disp_stock(disp_stock[6]),
			.disp_avg4(disp_avg4[6]),
			.disp_avg32(disp_avg32[6]),
			.disp_avg128(disp_avg128[6]),
			.change_flag(change_flag[6])
	);
	
		to_decimal td_S(
		.binary(final_dispS[399]),
		.clk(clk),
		.start(start_dec),
		.hundred_thousands(S_hundredthousand),
		.ten_thousands(S_tenthousand),
		.thousands(S_thousand),
		.hundreds(S_hundred),
		.tens(S_ten),
		.ones(S_one)
	);

		to_decimal td_E4(
		.binary(low_disp),
		.clk(clk),
		.start(start_dec),
		.hundred_thousands(E4_hundredthousand),
		.ten_thousands(E4_tenthousand),
		.thousands(E4_thousand),
		.hundreds(E4_hundred),
		.tens(E4_ten),
		.ones(E4_one)
	);
		to_decimal td_E32(
		.binary(high_disp),
		.clk(clk),
		.start(start_dec),
		.hundred_thousands(E32_hundredthousand),
		.ten_thousands(E32_tenthousand),
		.thousands(E32_thousand),
		.hundreds(E32_hundred),
		.tens(E32_ten),
		.ones(E32_one)
	);
		to_decimal td_E128(
		.binary(disp_stock_a3[399]),
		.clk(clk),
		.start(start_dec),
		.hundred_thousands(E128_hundredthousand),
		.ten_thousands(E128_tenthousand),
		.thousands(E128_thousand),
		.hundreds(E128_hundred),
		.tens(E128_ten),
		.ones(E128_one)
	);



	
	
	
   VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	
		
   always_ff @(posedge clk) begin
	/*
			disp_stock_a3[10] <= 10;
			disp_stock_a3[11] <= 11;
			disp_stock_a3[12] <= 12;
			disp_stock_a3[13] <= 13;
			disp_stock_a3[14] <= 14;
			disp_stock_a3[15] <= 15;
			disp_stock_a3[16] <= 16;
			*/
	/*
		disp_stock_x <= scale_dispS;
		disp_stock_a1 <= scale_dispA4;
		disp_stock_a2 <= scale_dispA32;
		disp_stock_a3 <= scale_dispA128;
	*/
		//------------------------------------------

		if (chipselect && write) begin
			if (writedata[31] == 1'b0) begin
				read_soft <= 1'b1;
			end
			if (writedata[31] == 1'b1) begin
				write_soft <= 1'b1; 
				stock_name <= writedata[23:17];
				if (writedata[16] == 1'b1) begin
					hard_range[16:1] <= writedata[15:0];
					hard_range[0] <= 1'b0;
					hard_range_flag <= 1'b1;
					//set the range from pass data
				end
				if (writedata[16] == 1'b0) begin
					hard_range_flag <= 1'b0;
				end

			end
		end
		
		if ((final_dispS[399] > final_dispA4[399]) && (final_dispA32[399] > final_dispA128[399])) begin
			bhs <= 2'b00; //buy
		end
		if ((final_dispS[399] > final_dispA4[399]) && (final_dispA32[399] < final_dispA128[399])) begin
			bhs <= 2'b01; //hold
		end
		if ((final_dispS[399] < final_dispA4[399]) && (final_dispA32[399] < final_dispA128[399])) begin
			bhs <= 2'b10; //sell
		end		
		if ((final_dispS[399] < final_dispA4[399]) && (final_dispA32[399] > final_dispA128[399])) begin
			bhs <= 2'b01; //hold
		end		
		
		

			if (read_soft == 1'b1) begin
				debug1 <= writedata[23:17];
				debug2 <= writedata[16:0];
				change_flag[writedata[23:17]] <= change_flag[writedata[23:17]] + 1'b1;
				data_send[writedata[23:17]] <= writedata[16:0]; 
				read_soft <= 1'b0;
			end
			if (write_soft == 1'b1) begin
				debug1 <= writedata[23:17];
				debug2 <= writedata[16:0];
				if (disp_delay == 0) begin
					request_disp[writedata[23:17]] <= 1'b1;
					output_id <= writedata[23:17];
					disp_delay <= disp_delay + 1'b1;
				end
				if (disp_delay > 0 && disp_delay < 420) begin //could change this to make a longer wait in between
					request_disp[writedata[23:17]] <= 1'b0;
					disp_delay <= disp_delay + 1'b1;
				end
				if (disp_delay >= 420) begin //also have to change this to make longer.
					
					disp_delay <= 0;
					write_soft <= 1'b0;
				end
				//wait 100 clock cycles
			end

		
		//make it so this looks at id, and then grabs it!
		fake2 <= disp_avg4[output_id];
		fake3 <= disp_avg32[output_id];
		fake4 <= disp_avg128[output_id];
		fake1 <= disp_stock[output_id];
		
		last_update_begin[output_id] <= update_begin[output_id];
		last_update_done[output_id] <= update_done[output_id];
		
		if (last_update_begin[output_id] != update_begin[output_id]) begin
			start_flag <= 1'b1;
			output_index <= 1'b1;
			begin_ranger <= 1'b1;
			final_dispS[0] <= disp_stock[output_id];
			final_dispA4[0] <= disp_avg4[output_id];
			final_dispA32[0] <= disp_avg32[output_id];
			final_dispA128[0] <= disp_avg128[output_id];
		end	
		
		if (last_update_done[output_id] != update_done[output_id]) begin
			start_flag <= 1'b0;
		end
		
		if (start_flag == 1'b1) begin
			begin_ranger <= 1'b0;
			final_dispS[output_index] <= disp_stock[output_id];
			final_dispA4[output_index] <= disp_avg4[output_id];
			final_dispA32[output_index] <= disp_avg32[output_id];
			final_dispA128[output_index] <= disp_avg128[output_id];
			output_index <= output_index + 1'b1;
		end
		
		if (done_range == 1'b1) begin
			scale_output <= 1'b1;
			in_ind <= 1'b0;
			if (hard_range_flag == 1'b0) begin
				range <= max - min;
			end
			if (hard_range_flag == 1'b1) begin
				range <= hard_range;
			end
			divide_min <= min;
		end
		
		if(scale_output == 1'b1) begin
			fd1 <= final_dispS[in_ind];
			fd2 <= final_dispA4[in_ind];
			fd3 <= final_dispA32[in_ind];
			fd4 <= final_dispA128[in_ind];
			in_ind <= in_ind + 1'b1;
			disp_stock_x[out_ind] <= sd1;
			disp_stock_a1[out_ind] <= sd2;
			disp_stock_a2[out_ind] <= sd3;
			disp_stock_a3[out_ind] <= sd4;
	
	
			if (out_ind == 399) begin
				scale_output <= 1'b0; //could use this as flag for Hang (with slight tweak.
				start_dec <= 1'b1;
				hang_start <= 1'b1;
				hang_count <= 2'b0;
				
				low_disp <= min;
				high_disp <= min + adj_range;				
			end
		end
		
		if (start_dec == 1'b1) begin
			start_dec <= 1'b0;
		end
		
		if (hang_start == 1'b1) begin
			if (hang_count < 2'b11) begin
				hang_count <= hang_count + 1'b1;
			end
			if (hang_count == 2'b11) begin
				hang_count <= 2'b0;
				hang_start <= 1'b0;
			end
		end
		


		
		
		
	end
endmodule
//---------------------
//-----------------------
module to_decimal(
	input logic clk,
	input logic start,
	input logic [16:0] binary,
	output logic [3:0] hundred_thousands,
	output logic [3:0] ten_thousands,
	output logic [3:0] thousands,
	output logic [3:0] hundreds,
	output logic [3:0] tens,
	output logic [3:0] ones
	);

	logic [4:0] i;
	logic [3:0] d_100000;
	logic [3:0] d_10000;
	logic [3:0] d_1000;
	logic [3:0] d_100;
	logic [3:0] d_10;
	logic [3:0] d_1;
	logic [16:0] in_val;
	logic sep_add;
	logic running;
	
	always_ff @(posedge clk) begin
		
		if (start == 1'b1) begin
			i <= 17;
			d_100000 <= 1'b0;
			d_10000 <= 1'b0;
			d_1000 <= 1'b0;
			d_100 <= 1'b0;
			d_10 <= 1'b0;
			d_1 <= 1'b0;
			in_val <= binary;
			running <= 1'b1;
		end
		if (running == 1'b1) begin
			if (i > 1'b0) begin
				if ((d_1 >= 5 || d_10 >= 5 || d_100 >= 5 || d_1000 >= 5 || d_10000 >= 5 || d_100000 >= 5)&&sep_add == 1'b0)begin
					if (d_100000 >= 5) begin
						d_100000 <= d_100000 + 3;
					end
					if (d_10000 >= 5) begin		
						d_10000 <= d_10000 + 3;
					end
					if (d_1000 >= 5) begin
						d_1000 <= d_1000 + 3;
					end
					if (d_100 >= 5) begin
						d_100 <= d_100 + 3;
					end
					if (d_10 >= 5) begin		
						d_10 <= d_10 + 3;
					end
					if (d_1 >= 5) begin
						d_1 <= d_1 + 3;
					end
					sep_add <= 1'b1;
				end
				if (d_1 < 5 && d_10 < 5 && d_100 < 5 && d_1000 < 5 && d_10000 < 5 && d_100000 < 5 && sep_add == 1'b0) begin
					d_100000 <= d_100000 << 1;
					d_100000[0] <= d_10000[3];
					d_10000 <= d_10000 << 1;
					d_10000[0] <= d_1000[3];
					d_1000 <= d_1000 << 1;
					d_1000[0] <= d_100[3];
					d_100 <= d_100 << 1;
					d_100[0] <= d_10[3];
					d_10 <= d_10 << 1;
					d_10[0] <= d_1[3];
					d_1 <= d_1 << 1;
					d_1[0] <= in_val[16];
					in_val <= in_val << 1;
					i <= i - 1;
				end
				if (sep_add == 1'b1) begin
					d_100000 <= d_100000 << 1;
					d_100000[0] <= d_10000[3];
					d_10000 <= d_10000 << 1;
					d_10000[0] <= d_1000[3];
					d_1000 <= d_1000 << 1;
					d_1000[0] <= d_100[3];
					d_100 <= d_100 << 1;
					d_100[0] <= d_10[3];
					d_10 <= d_10 << 1;
					d_10[0] <= d_1[3];
					d_1 <= d_1 << 1;
					d_1[0] <= in_val[16];
					in_val <= in_val << 1;
					i <= i - 1;
					sep_add <= 1'b0;
				end
			end	
			if (i == 0) begin
				running <= 1'b0;
				hundred_thousands <= d_100000;
				ten_thousands <= d_10000;
				thousands <= d_1000;
				hundreds <= d_100;
				tens <= d_10;
				ones <= d_1;
			end
		end
	end
endmodule


module divider(
	input logic clk,
	input logic [16:0] range,
	input logic [16:0] min,
	input logic [16:0] input_val1,
	input logic [16:0] input_val2,
	input logic [16:0] input_val3,
	input logic [16:0] input_val4,
	input logic [8:0] input_index,
	output logic [9:0] output_val1,
	output logic [9:0] output_val2,
	output logic [9:0] output_val3,
	output logic [9:0] output_val4,
	output logic [16:0] adj_range,
	output logic [8:0] output_index


	);
	
	logic [16:0] temp_in;
	logic [16:0] temp_range;
	logic [25:0] temp1;
	logic [25:0] temp2;
	logic [25:0] temp3;
	logic [25:0] temp4;
	logic [9:0] mid1;
	logic [9:0] mid2;
	logic [9:0] mid3;
	logic [9:0] mid4;
	logic [8:0] temp_out;
	logic [8:0] temp_ind;
	logic [8:0] mid_ind;
	logic round1;
	logic round2;
	logic round3;
	logic round4;
	always_ff @(posedge clk) begin
		// First stage
		temp1 <= 300*(input_val1 - min);
		temp2 <= 300*(input_val2 - min);
		temp3 <= 300*(input_val3 - min);
		temp4 <= 300*(input_val4 - min);
		temp_ind <= input_index;
		
		//Second stage
		if (range[16:15] == 2'b01 || range[16:14] == 3'b001) begin
			adj_range <= 17'b10000000000000000;
			mid1[9:0] <= temp1[25:16];
			mid2[9:0] <= temp2[25:16];
			mid3[9:0] <= temp3[25:16];
			mid4[9:0] <= temp4[25:16];
			if (temp1[15] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[15] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[15] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[15] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[15] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[15] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[15] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[15] == 1'b0) begin
			round4 <= 1'b0;
			end
		end
		if (range[16:13] == 4'b0001 || range[16:12] == 5'b00001) begin
			adj_range <= 17'b00100000000000000;
			mid1[9:0] <= temp1[23:14];
			mid2[9:0] <= temp2[23:14];
			mid3[9:0] <= temp3[23:14];
			mid4[9:0] <= temp4[23:14];
			if (temp1[13] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[13] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[13] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[13] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[13] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[13] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[13] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[13] == 1'b0) begin
			round4 <= 1'b0;
			end
		end
		if (range[16:11] == 6'b000001 || range[16:10] == 7'b0000001) begin
			adj_range <= 17'b00001000000000000;
			mid1[9:0] <= temp1[21:12];
			mid2[9:0] <= temp2[21:12];
			mid3[9:0] <= temp3[21:12];
			mid4[9:0] <= temp4[21:12];
			if (temp1[11] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[11] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[11] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[11] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[11] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[11] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[11] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[11] == 1'b0) begin
			round4 <= 1'b0;
			end
		end	
		if (range[16:9] == 8'b00000001 || range[16:8] == 9'b000000001) begin
			adj_range <= 17'b00000010000000000;
			mid1[9:0] <= temp1[19:10];
			mid2[9:0] <= temp2[19:10];
			mid3[9:0] <= temp3[19:10];
			mid4[9:0] <= temp4[19:10];
			if (temp1[9] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[9] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[9] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[9] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[9] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[9] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[9] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[9] == 1'b0) begin
			round4 <= 1'b0;
			end
		end	
		if (range[16:7] == 10'b0000000001 || range[16:6] == 11'b00000000001) begin
			adj_range <= 17'b00000000100000000;
			mid1[9:0] <= temp1[17:8];
			mid2[9:0] <= temp2[17:8];
			mid3[9:0] <= temp3[17:8];
			mid4[9:0] <= temp4[17:8];
			if (temp1[7] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[7] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[7] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[7] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[7] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[7] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[7] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[7] == 1'b0) begin
			round4 <= 1'b0;
			end
		end
		if (range[16:5] == 12'b000000000001 || range[16:4] == 13'b0000000000001) begin
			adj_range <= 17'b00000000001000000;
			mid1[9:0] <= temp1[15:6];
			mid2[9:0] <= temp2[15:6];
			mid3[9:0] <= temp3[15:6];
			mid4[9:0] <= temp4[15:6];
			if (temp1[5] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[5] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[5] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[5] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[5] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[5] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[5] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[5] == 1'b0) begin
			round4 <= 1'b0;
			end
		end	
		if (range[16:3] == 14'b00000000000001 || range[16:2] == 15'b000000000000001) begin
			adj_range <= 17'b00000000000010000;
			mid1[9:0] <= temp1[13:4];
			mid2[9:0] <= temp2[13:4];
			mid3[9:0] <= temp3[13:4];
			mid4[9:0] <= temp4[13:4];
			if (temp1[3] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[3] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[3] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[3] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[3] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[3] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[3] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[3] == 1'b0) begin
			round4 <= 1'b0;
			end
		end	
		if (range[16:1] == 16'b0000000000000001 || range[16:0] == 17'b00000000000000000) begin
			adj_range <= 17'b00000000000000100;
			mid1[9:0] <= temp1[11:2];
			mid2[9:0] <= temp2[11:2];
			mid3[9:0] <= temp3[11:2];
			mid4[9:0] <= temp4[11:2];
			if (temp1[1] == 1'b1) begin
			round1 <= 1'b1;
			end
			if (temp1[1] == 1'b0) begin
			round1 <= 1'b0;
			end
			if (temp2[1] == 1'b1) begin
			round2 <= 1'b1;
			end
			if (temp2[1] == 1'b0) begin
			round2 <= 1'b0;
			end
			if (temp3[1] == 1'b1) begin
			round3 <= 1'b1;
			end
			if (temp3[1] == 1'b0) begin
			round3 <= 1'b0;
			end
			if (temp4[1] == 1'b1) begin
			round4 <= 1'b1;
			end
			if (temp4[1] == 1'b0) begin
			round4 <= 1'b0;
			end
		end	
		mid_ind <= temp_ind;
		//Third stage
		output_val1 <= 320 - (mid1 + round1);
		output_val2 <= 320 - (mid2 + round2);
		output_val3 <= 320 - (mid3 + round3);
		output_val4 <= 320 - (mid4 + round4);
		output_index <= mid_ind;
	end

endmodule


module nothing_master(
			input logic clk,
			input logic [8:0] debug1,
			input logic [16:0] debug2,
			input logic begin_ranger,
			input logic [16:0] disp1,
			input logic [16:0] disp2,
			input logic [16:0] disp3,
			input logic [16:0] disp4,
			
			output logic done_range,
			output logic [16:0] max,
			output logic [16:0] min
			);
			
			
			logic find_range;
			logic ending;
			logic [8:0] counter;
			logic [16:0] min1;
			logic [16:0] max1;
			logic [16:0] min2;
			logic [16:0] max2;
			logic [16:0] min3;
			logic [16:0] max3;
			logic [16:0] min4;
			logic [16:0] max4;
			logic [16:0] range;
			
			
			
			
			
			always_ff @(posedge clk) begin
				if (ending == 1'b1) begin
					done_range <= 1'b0;
				end
				
				if (begin_ranger == 1'b1) begin
					find_range <= 1'b1;
					min1 <= 17'b11111111111111111;
					max1 <=17'b0;
					min2 <= 17'b11111111111111111;
					max2 <=17'b0;
					min3 <= 17'b11111111111111111;
					max3 <=17'b0;
					min4 <= 17'b11111111111111111;
					max4 <=17'b0;
					counter <= 1'b0;
					max <= 1'b0;
					min <= 1'b0;
				end
				
				if (find_range == 1'b1) begin
					counter <= counter + 1'b1;
					if (counter == 400) begin
						find_range <= 1'b0;
						done_range <= 1'b1;
						ending <= 1'b1;
						
						if (min1 < min2 && min1 < min3 && min1 < min4) begin
							min <= min1;
						end
						if (min2 < min1 && min2 < min3 && min2 < min4) begin
							min <= min2;
						end
						if (min3 < min1 && min3 < min2 && min3 < min4) begin
							min <= min3;
						end
						if (min4 < min1 && min4 < min2 && min4 < min3) begin
							min <= min4;
						end
						
						if (max1 > max2 && max1 > max3 && max1 > max4) begin
							max <= max1;
						end
						if (max2 > max1 && max2 > max3 && max2 > max4) begin
							max <= max2;
						end
						if (max3 > max1 && max3 > max2 && max3 > max4) begin
							max <= max3;
						end
						if (max4 > max1 && max4 > max2 && max4 > max3) begin
							max <= max4;
						end
	
					end
					
					if (disp1 < min1) begin
						min1 <= disp1;
					end
					if (disp2 < min2) begin
						min2 <= disp2;
					end
					if (disp3 < min3) begin
						min3 <= disp3;
					end
					if (disp4 < min4) begin
						min4 <= disp4;
					end
					if (disp1 > max1) begin
						max1 <= disp1;
					end
					if (disp2 > max2) begin
						max2 <= disp2;
					end
					if (disp3 > max3) begin
						max3 <= disp3;
					end
					if (disp4 > max4) begin
						max4 <= disp4;
					end
				end
			
			
			end
			
endmodule

module stock_master( 
			input logic clk,
			input logic [16:0] stock_in,
			//input logic [6:0] stock_id,
			input logic change_flag,
			input logic request_disp,
			output logic new_disp,
			//input logic change_input //switches between 1 and 0, if change, update on module and then execute
			//output logic [9:0] avg64_out,
			output logic [16:0] disp_stock,
			output logic [16:0] disp_avg4,
			output logic [16:0] disp_avg32,
			output logic [16:0] disp_avg128,
			output logic update_begin,
			output logic update_done //maybe treat this like 1/0 for flag as before!!
			
			//output logic [16:0] fake1,
			//output logic [16:0] fake2,
			//output logic [16:0] fake3,
			//output logic [16:0] fake4,
			
			//output logic [16:0] ema4_out,
			//output logic [16:0] ema32_out,
			//output logic [16:0] ema128_out

			);
				
			memory_chunk mem_4(
						.clk(clk),
						.din(stock_mem_in4),
						.a(stock_mem_addr4),
						.we(we_4),
						.dout(stock_mem_out4)
			);
			memory_chunk mem_32(
						.clk(clk),
						.din(stock_mem_in32),
						.a(stock_mem_addr32),
						.we(we_32),
						.dout(stock_mem_out32)
			);
			memory_chunk mem_128(
						.clk(clk),
						.din(stock_mem_in128),
						.a(stock_mem_addr128),
						.we(we_128),
						.dout(stock_mem_out128)
			);
			memory_chunk mem_S(
						.clk(clk),
						.din(stock_mem_inS),
						.a(stock_mem_addrS),
						.we(we_S),
						.dout(stock_mem_outS)
			);
		
			logic [16:0] stock_mem_out4;
			logic [16:0] stock_mem_in4;
			logic [13:0] stock_mem_addr4;
			logic [16:0] stock_mem_out32;
			logic [16:0] stock_mem_in32;
			logic [13:0] stock_mem_addr32;
			logic [16:0] stock_mem_out128;
			logic [16:0] stock_mem_in128;
			logic [13:0] stock_mem_addr128;
			logic [16:0] stock_mem_outS;
			logic [16:0] stock_mem_inS;
			logic [13:0] stock_mem_addrS;
			
			logic we_S;
			logic we_4;
			logic we_32;
			logic we_128;
			
			logic [16:0] temp_disp1;
			logic [16:0] temp_disp2;
			logic [16:0] temp_disp3;
			logic [16:0] temp_disp4;
			
			logic [16:0] ema_4;
			logic [16:0] ema_32;
			logic [16:0] ema_128;
			
			logic [23:0] past_ema128;
			logic [22:0] past_ema32;
			logic [22:0] past_ema4;
			
			logic [19:0] new_4;
			
			logic [23:0] sum_128;
			logic [22:0] sum_32;
			logic [22:0] sum_4;
			
			logic round_4;
			logic round_32;
			logic round_128;
			
			logic [8:0] last_stock_counter;
			logic [8:0] draw_counter;

			logic last_change_flag;
			logic sum_together;
			logic divide_sum;
			logic write_mem;
			logic wait_1;
			logic update_draw;
			logic drawing_done;
			logic zero_we;
			logic do_nothing;
			

			
			//NEED COUNTER FOR "IF CHANGE" type behavior
			//Rounding fixed, but still have issue of sum+stock_in != temp_sum 
			//why is temp_sum red invalid...maybe need clk as clock??
			always_ff @(posedge clk) begin
				last_change_flag <= change_flag;
				//ema4_out <= ema_4;
				//ema32_out <= ema_32;
				//ema128_out <= ema_128;
				
				if (change_flag != last_change_flag) begin
					past_ema128 <= 127*ema_128;
					past_ema32 <= 63*ema_32;
					past_ema4 <= 61*ema_4;
					new_4 <= 3*stock_in;
					sum_together <= 1'b1;
				end
				if (sum_together == 1'b1) begin
					sum_128 <= past_ema128 + stock_in;
					sum_32 <= past_ema32 + stock_in;
					sum_4 <= past_ema4 + new_4;
					divide_sum <= 1'b1;
					sum_together <= 1'b0;
				end
				if (divide_sum == 1'b1) begin
					ema_4[16:0] <= sum_4[22:6]; 
					if (sum_4[5] == 1'b1) begin
						round_4 <= 1'b1; 
					end
					ema_32[16:0] <= sum_32[22:6];
					if (sum_32[5] == 1'b1) begin
						round_32 <= 1'b1;
					end
					ema_128[16:0] <= sum_128[23:7];
					if (sum_128[6] == 1'b1) begin
						round_128 <= 1'b1;
					end	
					divide_sum <= 1'b0;
					wait_1 <= 1'b1;
				end

				if (round_4 == 1'b1) begin
					ema_4 <= ema_4 + 1'b1;
					round_4 <= 1'b0;
				end
				if (round_32 == 1'b1) begin
					ema_32 <= ema_32 + 1'b1;
					round_32 <= 1'b0;
				end
				if (round_128 == 1'b1) begin
					ema_128 <= ema_128 + 1'b1;
					round_128 <= 1'b0;
				end
				
				if (wait_1 == 1'b1) begin //need this in case rounding occurs (otherwise stock in values take non rounded value)
					wait_1 <= 1'b0;
					write_mem <= 1'b1;
				end
					
				//write to memory now, have flag of which reading from, set that up too!!!!!!! only read or write at one time.
				if (write_mem == 1'b1) begin
				
					stock_mem_addr4 <= last_stock_counter;
					stock_mem_addr32 <= last_stock_counter;
					stock_mem_addr128 <= last_stock_counter;
					stock_mem_addrS <= last_stock_counter;
					
					stock_mem_in4 <= ema_4;
					stock_mem_in32 <= ema_32;
					stock_mem_in128 <= ema_128;
					stock_mem_inS <= stock_in;
					
					we_S <= 1'b1;
					we_4 <= 1'b1;
					we_32 <= 1'b1;
					we_128 <= 1'b1;
					
					if (last_stock_counter >= 399) begin
						last_stock_counter <= 0;
					end
					if (last_stock_counter < 399) begin
						last_stock_counter <= last_stock_counter + 1'b1;
					end
					zero_we <= 1'b1;
					write_mem <= 1'b0;
				end

				if (zero_we) begin
					we_S <= 1'b0;
					we_4 <= 1'b0;
					we_32 <= 1'b0;
					we_128 <= 1'b0;
					zero_we <= 1'b0;
				end
				
				if (request_disp == 1'b1) begin
					stock_mem_addr4 <= last_stock_counter;
					stock_mem_addr32 <= last_stock_counter;
					stock_mem_addr128 <= last_stock_counter;
					stock_mem_addrS <= last_stock_counter;
					update_draw <= 1'b1;
				end
				
				if (update_draw == 1'b1) begin
					//make put the output of the mem in the write block syntax wise!!!!
					update_begin <= update_begin + 1'b1;
					disp_stock <= stock_mem_outS;
					disp_avg4 <= stock_mem_out4;
					disp_avg32 <= stock_mem_out32;
					disp_avg128 <= stock_mem_out128;
					
					//temp_disp1 <= stock_mem_outS;
					//temp_disp2 <= stock_mem_out4;
					//temp_disp3 <= stock_mem_out32;
					//temp_disp4 <= stock_mem_out128;
					
					new_disp <= new_disp + 1'b1;
					
					if (draw_counter < 399) begin
						if (stock_mem_addrS < 399) begin
							stock_mem_addr4 <= stock_mem_addr4 + 1'b1;
							stock_mem_addr32 <= stock_mem_addr32 + 1'b1;
							stock_mem_addr128 <= stock_mem_addr128 + 1'b1;
							stock_mem_addrS <= stock_mem_addrS + 1'b1;
						end
						if (stock_mem_addrS >= 399) begin
							stock_mem_addrS <= 1'b0;
							stock_mem_addr4 <= 1'b0;
							stock_mem_addr32 <= 1'b0;
							stock_mem_addr128 <= 1'b0;
						end	

						draw_counter <= draw_counter + 1'b1;
					end
					if (draw_counter >= 399) begin
						update_draw <= 1'b0;
						update_done <= update_done + 1'b1;
						draw_counter <= 0;
					end
					
					//only ends once 100 stocks have been been outputted!! make sure set draw_counter back to 0
				end
				//fake1 <= temp_disp1;
				//fake2 <= temp_disp2;
				//fake3 <= temp_disp3;
				//fake4 <= temp_disp4;

				
			end //for always_ff
			
			
			
			

endmodule

module memory_chunk(input logic        clk,
	      input logic [13:0]  a,
	      input logic [16:0]  din,
	      input logic 	 we,
	      output logic [16:0] dout);
   
   logic [16:0] 			 mem [399:0];

   always_ff @(posedge clk) begin
      if (we) mem[a] <= din;
      dout <= mem[a];
   end
        
endmodule
