/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [31:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [2:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);


	 
   logic [9:0] x_coord, y_coord_in, y_coord_out, y_coord;
	logic [1:0] x_code, y_code;
	logic [9:0] radius;
	logic we;
	logic [2:0] mem_address;
	logic [31:0] display;
	logic [19:0] new_stock, stored_stock;
	logic [4:0] stock_address;
	logic [24:0] sum32;
	logic [5:0] sum_state;
	logic change_check;
	logic display_choice;
	//-----------------------------------------
	logic [9:0] disp_stock_x [1023:0];
	logic [9:0] disp_stock_a1 [1023:0];
	logic [9:0] disp_stock_a2 [1023:0];
	logic [9:0] disp_stock_a3 [1023:0];
	logic send_to_vga;
	
	//-----------------------------------------

   VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	
	memory memory_instance(
		.clk(clk),
		.a(stock_address),
		.din(new_stock),
		.we(we),
		.dout(stored_stock)
	);
		
   always_ff @(posedge clk) begin

	 //part of memory write process nca001
	 /*
	  display[19:0] <= stored_stock[19:0];
	  display[31:20] <= 12'b0;
	  */
	  //end part nca001
	  if (sum_state[5:0] == 6'b000000) begin
	  
	  end
	  
	  
	  
	  
	  

	  
     if (reset) begin
	  x_coord[9:0] <=  10'b0100110110;
	  y_coord[9:0] <=  10'b0011001000;
	  radius[9:0]  <= 10'b0000011111;
//	hex0 <= 8'b11111111; // 4
//	hex1 <= 8'b01111111; // 8
//	hex2 <= 8'b01100110; // 4
//	hex3 <= 8'b10111111; // 0
//	hex4 <= 8'b00111000; // L
//	hex5 <= 8'b01110111; // A
//	hex6 <= 8'b01111100; // b
//	hex7 <= 8'b01001111; // 3

     end else if (chipselect && write) begin
			//NCA002
			
			send_to_vga <= writedata[31];
			if (writedata[28:27] == 2'b00) begin
				disp_stock_x[writedata[19:10]] <= writedata[9:0];
			end
			if (writedata[28:27] == 2'b01) begin
				disp_stock_a1[writedata[19:10]] <= writedata[9:0];
			end
			if (writedata[28:27] == 2'b10) begin
				disp_stock_a2[writedata[19:10]] <= writedata[9:0];
			end
			if (writedata[28:27] == 2'b11) begin
				disp_stock_a3[writedata[19:10]] <= writedata[9:0];
			end
			//NCA002
		
		
		
		
		
		//radius[9:0]  <= 10'b0000011111;
		
		//this is for writing to a memory  nca001
		/*
		new_stock[19:0] <= writedata[19:0];
		stock_address[4:0] <= writedata[24:20];
		change_check <= writedata[25];
		display_choice <= writedata[26];
		we <= writedata[27];
		*/
		//end writing to that memory nca001
		
		//display[31:0] <= writedata[31:0];

	  
		/*
	   we <= writedata[7];
		mem_address[2:0] <= writedata[6:4];
		x_code[1:0] <= writedata[3:2];
		y_code[1:0] <= writedata[1:0];
	   //
		// translation
		
		//need to take x_code to x_coord, and y_code to input to mem, and output to y_coord and fix radius
		
		// HEEERREEEEE
		
		case (x_code)
			2'h0 : x_coord[9:0] <= 10'b0001100100;
			2'h1 : x_coord[9:0] <= 10'b0011001000;
			2'h2 : x_coord[9:0] <= 10'b0100101100;
			2'h3 : x_coord[9:0] <= 10'b0110010000;
		endcase
		
		case(y_code)
			2'h0 : y_coord_in[9:0] <= 10'b0001100100;
			2'h1 : y_coord_in[9:0] <= 10'b0011001000;
			2'h2 : y_coord_in[9:0] <= 10'b0100101100;
			2'h3 : y_coord_in[9:0] <= 10'b0110010000;
		endcase
		y_coord <= y_coord_out;
		
		*/

		
		//
	  
	   
 //    case (address)
//		3'h0 : 
//		3'h0 : x_coord[7:0] <= writedata;
//		3'h1 : x_coord[9:8] <= writedata[1:0];
//		3'h2 : y_coord[7:0] <= writedata;
//		3'h3 : y_coord[9:8] <= writedata[)1:0];
//		3'h4 : radius[7:0] <= writedata[7:0];
//		3'h5 : mem_address[3:0] <= writedata[3:0];
//		3'h6 : we <= writedata[0];
				//radius[9:8] <= 2'b00;
		//	 3'h0 : hex0 <= writedata; // 3
//	 3'h1 : hex1 <= writedata;
//	 3'h2 : hex2 <= writedata;
//	 3'h3 : hex3 <= writedata;
//	 3'h4 : hex4 <= writedata;
//	 3'h5 : hex5 <= writedata;
//	 3'h6 : hex6 <= writedata;
//	 3'h7 : hex7 <= writedata;
//   endcase
	end
	end
endmodule

//			 

//
module memory(input logic        clk,
	      input logic [4:0]  a,
	      input logic [19:0]  din,
	      input logic 	 we,
	      output logic [19:0] dout);
   
   logic [19:0] 			 mem [31:0];

   always_ff @(posedge clk) begin
      if (we) mem[a] <= din;
      dout <= mem[a];
   end
        
endmodule

//------------------------------------------------------
//Nathan
/*
//The memory modules needed
module memory24(input logic        clk,
	      input logic [4:0]  a,
	      input logic [19:0]  din,
	      input logic 	 we,
	      output logic [19:0] dout);
   
   logic [19:0] 			 mem [31:0];

   always_ff @(posedge clk) begin
      if (we) mem[a] <= din;
      dout <= mem[a];
   end
        
endmodule

module memory5(input logic        clk,
	      input logic [2:0]  a,
	      input logic [19:0]  din,
	      input logic 	 we,
	      output logic [19:0] dout);
   
   logic [19:0] 			 mem [7:0];

   always_ff @(posedge clk) begin
      if (we) mem[a] <= din;
      dout <= mem[a];
   end
        
endmodule







module stock_master( 
			input logic clk,
			input logic [17:0] stock_value,
			input logic change_input //switches between 1 and 0, if change, update on module and then execute
			output logic [17:0] avg);
		//-----------------------------------------------
		logic change_local;
		logic hour_flag;
		logic five_flag;
		logic we_hr;
		logic we_five;
		
		logic [23:0] sum60;
		logic [23:0] sum5;
		
		logic [5:0] hr_count;
		logic [2:0] five_count;
		
		logic [23:0] hr_avg;
		logic [23:0] five_avg;
		logic [23:0] hr_avg_out;
		
		logic [4:0] hr_address;
		logic [2:0] five_address;
		
		memory24 memory24_instance(
			.clk(clk),
			.a(hr_address),
			.din(hr_avg),
			.we(we_hr),
			.dout(hr_avg_out)
		);
		
		always_ff@(posedge clk) begin
			if (change_local == change_input) begin
				change_local <= change_input;
				
				sum60 <= sum60 + stock_value;
				sum5 <= sum5 + stock_value;
				hr_count <= hr_count + 1'b1;
				five_count <= five_count + 1'b1;	
			end
			//---------------------------------------------
			// When hit hr and five counts, take avg, set flag, and reset counter
			// Will division take more than one clock cycle??
			if (hr_count == 6'b111100) begin
				hr_count <= 6'b000000;
				hr_avg <= hr_count/6'b111100;
				hour_flag <= 1'b1;
				we_hr <= 1'b1;
			end
			if (five_count == 3'b101) begin
				five_count <= 3'b000;
				five_avg <= five_count/3'b101;
				five_flag <= 1'b1;
				we_five <= 1'b1;
			end
			//----------------------------------------------
			// Put simple averages in memory 
			
			if (hour_flag == 1'b1) begin
				hour_flag <= 1'b0;
				if (hr_address == 5'b10111) begin
					hr_address <= 5'b00000;
				end
				we_hour <= 1'b0;
			end
			if (five_flag == 1'b1) begin
				five_flag <= 1'b0
				
				we_five <= 1'b0;
			end
		
		
		
		end
			

endmodule
*/
//End Nathan
//-----------------------------------------------------------




















/*
module state_machine(input logic clk, reset,
							input logic advance,
							output logic [19:0] avg32, avg8);
		
		typedef enum logic [5:0] {S0, S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S25, S26, S27, S28, S29, S30, S31} state_t;
		state_t state, next_state;
		
		logic [24:0] sum32, sum8;
		
		memory memory_instance(
		.clk(clk),
		.a(stock_address),
		.din(new_stock),
		.we(we),
		.dout(stored_stock)
	);
		
		
		always_ff @(posedge clk) state <= next_state;
		
		always_comb begin
		{avg32[19:0], avg8[19:0]} = 20'b0;
		next_state = state;
		if (reset) next_state = S0;
		else case (state)
			S0: begin sum32 <= 32'b0;
			    if (full) next_state = S1;
				 
			S1: begin sum32 <= sum32 + ;
			    if (full) next_state = S1;
		  
				
		
		
		
		
		



endmodule

*/

