#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

typedef struct {
  unsigned char addr;  // typically: command for fpga
  unsigned short data; // typically: concatenated max-min (ie. max*2^8 + min)
} vga_led_arg_t;

#define VGA_LED_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_LED_WRITE _IOW(VGA_LED_MAGIC, 1, vga_led_arg_t *)
#define VGA_LED_READ  _IOWR(VGA_LED_MAGIC, 2, vga_led_arg_t *)

#endif
