module WTA(input logic [7:0]	v,
	       input logic [1:0]	d0, d1, d2, d3, d4, d5, d6, d7,

	       output logic [2:0] 	spk_idx,
			 output logic			v_output);

	logic [3:0] v4;
	logic [1:0] v2;
	
	logic i4_0, i4_1, i4_2, i4_3;
	logic it1, it2;
	logic i2_0, i2_1;
	
	logic [1:0] d4_0, d4_1, d4_2, d4_3;
	logic [1:0] d2_0, d2_1;
	logic [1:0] d_fin;
	
	WINNER	w4_0(.vA(v[0]), .vB(v[1]), .distA(d0), .distB(d1), .dist_l(d4_0), .v(v4[0]), .sel(i4_0));
	WINNER	w4_1(.vA(v[2]), .vB(v[3]), .distA(d2), .distB(d3), .dist_l(d4_1), .v(v4[1]), .sel(i4_1));
	WINNER	w4_2(.vA(v[4]), .vB(v[5]), .distA(d4), .distB(d5), .dist_l(d4_2), .v(v4[2]), .sel(i4_2));
	WINNER	w4_3(.vA(v[6]), .vB(v[7]), .distA(d6), .distB(d7), .dist_l(d4_3), .v(v4[3]), .sel(i4_3));
	
	WINNER	w2_0(.vA(v4[0]), .vB(v4[1]), .distA(d4_0), .distB(d4_1), .dist_l(d2_0), .v(v2[0]), .sel(i2_0));
	WINNER	w2_1(.vA(v4[2]), .vB(v4[3]), .distA(d4_2), .distB(d4_3), .dist_l(d2_1), .v(v2[1]), .sel(i2_1));
	
	WINNER	wFin(.vA(v2[0]), .vB(v2[1]), .distA(d2_0), .distB(d2_1), .dist_l(d_fin), .v(v_output), .sel(spk_idx[2]));
	
	assign it1 = (i2_0)?i4_0:i4_1;
	assign it2 = (i2_1)?i4_2:i4_3;
	
	assign spk_idx[1] = (spk_idx[2])?i2_0:i2_1;
	assign spk_idx[0] = (spk_idx[1])?it1:it2;

endmodule

module WINNER(input logic		vA,
	       input logic 	  		vB,
	       input logic [1:0]	distA,
	       input logic [1:0]	distB,

	       output logic [1:0] 	dist_l,
			 output logic			v,
			 output logic			sel);

	logic		lesser;
	
	assign lesser = distA < distB;
	assign sel = (vA&vB)?vB:lesser;
	assign v = vA | vB;
	assign dist_l = (sel)?distA:distB;

endmodule
