module GRIDFIND(input logic [11:0] spk_f, 
					input logic [41:0] Bph, 
					input logic [6:0] vph, 
					output logic [5:0] grid_idx);

        REGION peakregion(.boundary(Bph), .v(vph), .feature(spk_f[11:6]), .idx(grid_idx[5:3]));
        REGION hypregion(.boundary(Bph), .v(vph), .feature(spk_f[5:0]), .idx(grid_idx[2:0]));

endmodule

module REGION(input logic [41:0] boundary, 
				input logic [6:0] v, 
				input logic [5:0] feature, 
				output logic [2:0] idx);

        logic [6:0]                      gr, vgr;

        assign gr[6] = feature >= boundary[41:36];
        assign gr[5] = feature >= boundary[35:30];
        assign gr[4] = feature >= boundary[29:24];
        assign gr[3] = feature >= boundary[23:18];
        assign gr[2] = feature >= boundary[17:12];
        assign gr[1] = feature >= boundary[11:6];
        assign gr[0] = feature >= boundary[5:0];

        assign vgr = gr&v;

        assign idx = vgr[6]+vgr[5]+vgr[4]+vgr[3]+vgr[2]+vgr[1]+vgr[0];

endmodule
