module GC(input logic reset,
				input logic [11:0] spk_f, 
				input logic [41:0] Bph, 
				input logic [6:0] vph, 
				//input logic start,
				input logic clk, update, leak, infm,
				output logic v_output,
				output logic [2:0] spk_idx,
				output logic [7:0] ocp);

	logic [5:0]	gridi;
	logic [5:0]	grid_idx;

	GRIDFIND gridmod(.*);
//	GRIDFIND gridmod(.spk_f(spk_f), .Bph(Bph), .vph(vph), .grid_idx(grid_idx));
	CLUSTERS modc(.grid_idx(gridi), .*);
//	CLUSTERS modc(.clk(clk), .start(start), .update(update), .leak(leak), .grid_idx(gridi), .v_output(v_output), .spk_idx(spk_idx));

	always_ff @(posedge clk)
	begin
		gridi <= grid_idx;
	end

endmodule

module CLUSTERS(input logic reset,
					input logic clk, 
					//input logic start, 
					input logic update, leak, infm, 
					input logic [5:0] grid_idx, 
					output logic v_output, 
					output logic [2:0] spk_idx,
					output logic [7:0] ocp);

	logic [1:0]	d0,d1,d2,d3,d4,d5,d6,d7;
	logic [1:0]	wd0,wd1,wd2,wd3,wd4,wd5,wd6,wd7;
	logic [7:0]	v, vwta;
	logic [7:0] hits;
	
	always_ff @(posedge clk)
	begin
		vwta <= v;
	end

	CAM_CLUSTER cl(.*);
//	CAM_CLUSTER cl(.reset(reset), .clk(clk), .start(start), .update(update), .leak(leak), .grid_idx(grid_idx), .d0(d0),.d1(d1),.d2(d2),.d3(d3),.d4(d4),.d5(d5),.d6(d6),.d7(d7), .v(v));
//	WTA wtamod(.*);
	WTA wtamod(.v(vwta), .d0(wd0),.d1(wd1),.d2(wd2),.d3(wd3),.d4(wd4),.d5(wd5),.d6(wd6),.d7(wd7), .spk_idx(spk_idx), .v_output(v_output));

endmodule
