module CAM_CLUSTER(input logic clk, reset,
						//input logic start, 
						input logic update, 
						input logic leak, 
						input logic [5:0] grid_idx, 
						output logic [1:0] d0,
						output logic [1:0] d1,
						output logic [1:0] d2,
						output logic [1:0] d3,
						output logic [1:0] d4,
						output logic [1:0] d5,
						output logic [1:0] d6,
						output logic [1:0] d7, 
						output logic [7:0] v,
						output logic [7:0] ocp);

		logic [7:0] hits;
		logic [7:0] nC;
		logic [7:0] nC_c;
		logic match;

        assign match = |(hits&ocp);

        VAC vac_find(.nC(nC_c), .grow(~match), .*);
//		  VAC vac_find(.ocp(ocp), .update(update), .nC(nC_c), .grow(~match));
		  CAMENTRY e0(.clk(clk), .newC(nC[0]), .grow(~match), .hit(hits[0]), .adjacent(d0), .v_in(v[0]), .v_clu(ocp[0]), .*);
        CAMENTRY e1(.newC(nC[1]), .grow(~match), .hit(hits[1]), .adjacent(d1), .v_in(v[1]), .v_clu(ocp[1]), .*);
        CAMENTRY e2(.newC(nC[2]), .grow(~match), .hit(hits[2]), .adjacent(d2), .v_in(v[2]), .v_clu(ocp[2]), .*);
        CAMENTRY e3(.newC(nC[3]), .grow(~match), .hit(hits[3]), .adjacent(d3), .v_in(v[3]), .v_clu(ocp[3]), .*);
        CAMENTRY e4(.newC(nC[4]), .grow(~match), .hit(hits[4]), .adjacent(d4), .v_in(v[4]), .v_clu(ocp[4]), .*);
        CAMENTRY e5(.newC(nC[5]), .grow(~match), .hit(hits[5]), .adjacent(d5), .v_in(v[5]), .v_clu(ocp[5]), .*);
        CAMENTRY e6(.newC(nC[6]), .grow(~match), .hit(hits[6]), .adjacent(d6), .v_in(v[6]), .v_clu(ocp[6]), .*);
        CAMENTRY e7(.newC(nC[7]), .grow(~match), .hit(hits[7]), .adjacent(d7), .v_in(v[7]), .v_clu(ocp[7]), .*);
//        CAMENTRY e0(.clk(clk), .start(start), .newC(nC[0]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[0]), .adjacent(d0), .v_in(v[0]), .v_clu(ocp[0]));
//        CAMENTRY e1(.clk(clk), .start(start), .newC(nC[1]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[1]), .adjacent(d1), .v_in(v[1]), .v_clu(ocp[1]));
//        CAMENTRY e2(.clk(clk), .start(start), .newC(nC[2]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[2]), .adjacent(d2), .v_in(v[2]), .v_clu(ocp[2]));
//        CAMENTRY e3(.clk(clk), .start(start), .newC(nC[3]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[3]), .adjacent(d3), .v_in(v[3]), .v_clu(ocp[3]));
//        CAMENTRY e4(.clk(clk), .start(start), .newC(nC[4]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[4]), .adjacent(d4), .v_in(v[4]), .v_clu(ocp[4]));
//        CAMENTRY e5(.clk(clk), .start(start), .newC(nC[5]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[5]), .adjacent(d5), .v_in(v[5]), .v_clu(ocp[5]));
//        CAMENTRY e6(.clk(clk), .start(start), .newC(nC[6]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[6]), .adjacent(d6), .v_in(v[6]), .v_clu(ocp[6]));
//        CAMENTRY e7(.clk(clk), .start(start), .newC(nC[7]), .grow(~match), .update(update), .leak(leak), .grid_idx(grid_idx), .hit(hits[7]), .adjacent(d7), .v_in(v[7]), .v_clu(ocp[7]));

  always_ff @(negedge clk)
  begin
    nC <= nC_c;
  end

endmodule

module VAC(input logic [7:0] ocp,
				input logic update, grow,
				output logic [7:0] nC);
				
        assign nC[0] = update & grow&(~ocp[0]);
        assign nC[1] = update & grow&(~ocp[1])&(~nC[0]);
        assign nC[2] = update & grow&(~ocp[2])&(~(nC[1]|nC[0]));
        assign nC[3] = update & grow&(~ocp[3])&(~(nC[2]|nC[1]|nC[0]));
        assign nC[4] = update & grow&(~ocp[4])&(~(nC[3]|nC[2]|nC[1]|nC[0]));
        assign nC[5] = update & grow&(~ocp[5])&(~(nC[4]|nC[3]|nC[2]|nC[1]|nC[0]));
        assign nC[6] = update & grow&(~ocp[6])&(~(nC[5]|nC[4]|nC[3]|nC[2]|nC[1]|nC[0]));
        assign nC[7] = update & grow&(~ocp[7])&(~(nC[6]|nC[5]|nC[4]|nC[3]|nC[2]|nC[1]|nC[0]));

endmodule


module CAMENTRY(input logic clk, reset,
					//input logic start, 
					input logic newC, 
					input logic grow, 
					input logic update, 
					input logic leak, 
					input logic [5:0] grid_idx, 
					output logic hit, 
					output logic [1:0] adjacent, 
					output logic v_in, 
					output logic v_clu);

        logic [1:0]	u;
        logic [8:0]	entry;

        //logic [1:0]	updU;
        logic [1:0]	uout;

        logic load;
		  logic v;
		  logic hit_raw;
        //logic [1:0] u_input, u_ini;

	BIMODAL bm0(.load(load), .in(u), .up(hit), .down(leak), .out(uout));
	GRIDADJ ga0(.grid_idx(grid_idx), .c_idxes(entry), .hit(hit), .adjacent(adjacent), .v(v));

	assign v_clu = |u;
	assign v_in = v&v_clu;
	assign load = reset|update;


	always_ff @(negedge clk)
	begin
		if (load) begin
			//u <= u_input;
			//u <= (newC)?2'b01:((start)?2'b00:uout);
			u <= (newC)?2'b01:uout;
		end
		if (newC) begin
			entry <= grid_idx;
		end
	end
	
//	always @(newC|sc)
//	begin
//		if (newC|sc) begin
//			entry <= grid_idx;
//		end
//	end

//	always @(negedge clk)
//	begin
//		updU <= uout;
//	end

endmodule

module BIMODAL(input logic load,
					input logic [1:0] in,
					input logic up, 
					input logic down, 
					output logic [1:0] out);

	  logic [1:0]	u, d, x, y;
	  // up
	  assign u[1] = |in;
	  assign u[0] = ~(in[0]&(~in[1]));
	  // down
	  assign d[1] = &in;
	  assign d[0] = in[1]&(~in[0]);

	  assign x = (up&u[1])?u:in;
	  assign y = (down)?d:x;
	  assign out = (load)?y:in;

endmodule

module GRIDADJ(input logic [5:0] grid_idx, 
					input logic [5:0] c_idxes, 
					output logic [1:0] adjacent, 
					output logic hit,
					output logic v);

        logic [2:0]                      match_b, adj_b, c_b;

        ATTR_F  attr_fp(.A(grid_idx[5:3]), .B(c_idxes[5:3]), .match(match_b[1]), .adj(adj_b[1]), .c(c_b[1]));
        ATTR_F  attr_fh(.A(grid_idx[2:0]), .B(c_idxes[2:0]), .match(match_b[0]), .adj(adj_b[0]), .c(c_b[0]));

        assign v = &c_b;
        assign hit = &match_b;
        assign adjacent = adj_b[2]+adj_b[1]+adj_b[0];

endmodule

module ATTR_F(input logic[2:0] A, 
					input logic[2:0] B, 
					output logic match, 
					output logic adj, 
					output logic c);


        logic [2:0]              X, E;
        logic                            m, n;

        assign X = A^B;
        assign E = ~X;
        assign m = A[2]^A[1];
        assign n = A[1]^A[0];
        assign match = ~|X;
        assign adj = X[0]&((E[2]&E[1])|(E[2]&X[1]&n)|(X[2]&X[1]&m&(~n)));
        assign c = match | adj;

endmodule
