/*
 * "Hallway" image generator
 * 
 * Draws lines starting from evenly-spaced points around the four
 * corners of the screen to a central point, which is moved once a frame
 * 
 * Stephen A. Edwards
 */
module hallway(input logic         clk, reset,
	       input logic 	   VGA_VS,
	       
	       input logic 	   done,
	       
	       output logic [10:0] x0, y0, x1, y1,
	       output logic 	   start, pixel_color);

   typedef enum logic [4:0] {S_TOP, S_RIGHT, S_BOTTOM, S_LEFT, VBLANK} state_t;

   state_t state;

   always_ff @(posedge clk) begin
      start <= 0;      
      if (reset) begin
	 pixel_color <= 1;
	 start <= 1;
	 x0 <= 0;
	 y0 <= 0;
	 x1 <= 320;
	 y1 <= 200;	
	 state <= S_TOP;
      end else
	case (state)
	  S_TOP:
	    if (done) begin
 	       start <= 1;	      
               if (x0 < 620)
		 x0 <= x0 + 10'd 10;
	       else begin
		  state <= S_RIGHT;
		  x0 <= 639;
 	          y0 <= 0;
	       end
	    end

	  S_RIGHT:
	    if (done) begin
	       start <= 1;
	       if (y0 < 460)
		 y0 <= y0 + 10'd 10;
	       else begin
		  state <= S_BOTTOM;
		  x0 <= 639;
		  y0 <= 479;
	       end
	    end

	  S_BOTTOM:
	    if (done) begin
	       start <= 1;
	       if (x0 > 20)
		 x0 <= x0 - 10'd 10;
	       else begin
		  state <= S_LEFT;
		  x0 <= 0;
		  y0 <= 479;
	       end
	    end

	  S_LEFT:
	    if (done) begin
	       start <= 1;
	       if (y0 > 20)
		 y0 <= y0 - 10'd 10;
	       else begin
		  state <= S_TOP;
		  x0 <= 0;
		  y0 <= 0;
		  pixel_color <= ~pixel_color;
		  if (~pixel_color)
		    if (x1 < 600)
		      x1 <= x1 + 10'd 3;
		    else begin
		       x1 = 40;
		       if (y1 < 440)
			 y1 <= y1 + 10'd 3;
		       else
			 y1 <= 40;
		    end
		  else begin
		     state <= VBLANK;
		     start <= 0;
		  end
	       end
	    end

	  VBLANK:
	    if (~VGA_VS) begin
	       start <= 1;
	       state <= S_TOP;
	    end
	  
	endcase
   end
   
endmodule
