#ifndef _FIFO_DATA_H
#define _FIFO_DATA_H

#include <linux/ioctl.h>

#define FIFO_MAGIC 'q'

#define SINGLE_PACKET_CHANNEL0         0b00000000000000000000000000000011
#define START_PACKET_CHANNEL0          0b00000000000000000000000000000001
#define END_PACKET_CHANNEL0            0b00000000000000000000000000000010
#define DONE_END_PACKET_CHANNEL0       0b00000000000000010000000000000010
#define DONE_SINGLE_PACKET_CHANNEL0    0b00000000000000010000000000000011
#define DONE_MASK                      0b00000000000000010000000000000000

#define FIFO_SIZE 16
#define FIFOS 28

#define IS_DONE(A) \
	((A) & DONE_MASK)

#define MIN(A,B) ((A) < (B) ? (A) : (B))

typedef struct {
	unsigned char length;
	unsigned char done;
	unsigned char fifo;
	int* buf;
} opcode;

/* ioctls and their arguments */
#define FIFO_WRITE_DATA _IOW(FIFO_MAGIC, 1, opcode *)
#define FIFO_READ_DATA  _IOR(FIFO_MAGIC, 2, opcode *)
#define FIFO_READ_STATUS _IOR(FIFO_MAGIC, 3, int*)
#endif
