if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

set length 32
set fifo_in1 0x468
set fifo_in2 0x460
set fifo_in3 0x458
set fifo_in4 0x450
set fifo_out1 0x440
set fifo_out2 0x448
set fifo_out3 0x438
set fifo_out4 0x430

for {set i 0} {$i < $length} {incr i} {
	master_write_32 $m $fifo_in1 [ expr $length - $i ]
	master_write_32 $m $fifo_in2 $i 
	master_write_32 $m $fifo_in3 [ expr $length - $i ]
	master_write_32 $m $fifo_in4 [ expr $length - $i ]
}

for {set i 0} {$i < $length} {incr i} {
	set tmp1 [master_read_32 $m $fifo_out1 1]
	set tmp2 [master_read_32 $m $fifo_out2 1]
	puts "$tmp1 $tmp2"

	master_read_32 $m $fifo_out3 1
	master_read_32 $m $fifo_out4 1
}

puts "\n******\n"

# set length 10

# #send less data than sort pipeline length
# for {set i 0} {$i < $length} {incr i} {
# 	master_write_32 $m $fifo_in1 [ expr $length - $i ]
# 	master_write_32 $m $fifo_in2 [ expr $length - $i ]
# 	master_write_32 $m $fifo_in3 [ expr $length - $i ]
# 	master_write_32 $m $fifo_in4 [ expr $length - $i ]
# }

# #set the done bit in the specs
# master_write_32 $m [expr $fifo_in1 +4]  0x10002
# master_write_32 $m [expr $fifo_in2 +4]  0x10002
# master_write_32 $m [expr $fifo_in3 +4]  0x10002
# master_write_32 $m [expr $fifo_in4 +4]  0x10002

# #push data with done bit
# master_write_32 $m $fifo_in1 100
# master_write_32 $m $fifo_in2 100
# master_write_32 $m $fifo_in3 100
# master_write_32 $m $fifo_in4 100

# for {set i 0} {$i < [expr $length + 1]} {incr i} {
# 	set tmp1 [master_read_32 $m $fifo_out1 1]
# 	set tmp2 [master_read_32 $m $fifo_out2 1]
# 	puts "$tmp1 $tmp2"

# 	master_read_32 $m $fifo_out3 1
# 	master_read_32 $m $fifo_out4 1
# }
