import subprocess
import sys
import re
import random
import operator
import math
import pdb
from itertools import izip_longest

def sort_tile(input_data,output_data,width,length):
    to_sort_all = map(None,*input_data)
    # print splatted_padded_data
    # to_sort_all =  zip(splatted_padded_data)
    #print to_sort_all
    for i in xrange(0,len(to_sort_all),length+1):
        to_sort = to_sort_all[i:i+length+1]
        
        for j in xrange(width,0,-1):
            to_sort = sorted(to_sort,key=operator.itemgetter(j-1))

        to_sort_all[i:i+length+1] = to_sort

        #print i,to_sort_all
    sorted_with_none = zip(*to_sort_all)
    return map(lambda x : [y for y in x if y is not None] , sorted_with_none)

def print_run(input_data,output_data,golden):
    #function for debugging
    input_col_to_str = lambda x : reduce ( operator.add , map( "{0:>4d}".format , x) )
    print "\nINPUT:\n","\n".join( map( input_col_to_str,input_data) )

    try:
        print "OUTPUT:\n","\n".join(map( input_col_to_str,output_data))
    except Exception as e:
        print "PROBLEM PRINTING OUTPUT",e
        pdb.set_trace()

    try:
        print "GOLDEN:\n","\n".join(map( input_col_to_str,golden))
    except Exception as e:
        print "PROBLEM PRINTING GOLDEN",e
        pdb.set_trace()


if len(sys.argv) > 1:
    number_of_tests = int(sys.argv[1])
else:
    number_of_tests = 10

random.seed()

#compile all the code
p  = subprocess.Popen("vlog ./my_files/interfaces.sv ./my_files/buffer.sv ./my_files/buffer_ctrl.sv ./my_files/sort_tile.sv ./my_files/sort_row.sv ./my_files/sort_mesh.sv ./my_files/sort_mesh_tb.sv".split(),stdout = subprocess.PIPE,stderr=subprocess.PIPE)
stdout,stderr = p.communicate()
assert(len(stderr) == 0)
print stdout

for i in xrange(number_of_tests):

    seed            = random.randint(0,1000000)
    send_threshold  = random.randint(0,9)
    ready_threshold = random.randint(0,9)
    length          = random.randint(2,9)
    width           = random.randint(2,6)

    #call modelsim
    cmd           = "vsim -c sort_mesh_tb -gSEED={0:<8d} -gSEND_THRESHOLD={1} -gREADY_THRESHOLD={2} -gWIDTH={3} -gLENGTH={4} -do \"run -all\"".format(seed,send_threshold,ready_threshold,width,length)
    sys.stdout.write( cmd + ": ")
    
    p             = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
    stdout,stderr = p.communicate()
    #print stdout
    assert(len(stderr) == 0)

    #check results
    input_data = [[] for x in xrange(width)]
    output_data = [[] for x in xrange(width)]
    for line in stdout.split("\n"):

        if re.match("# TIME",line):
            stuff         = line.split()
            sent          = ( stuff[3].strip() == "SENT" )
            index         = int(stuff[4])
            el            = int(stuff[5])
            if sent:
                input_data[index].append(el)
            else:
                output_data[index].append(el)

            #print line
                
    if len(input_data) == 0:
        raise NotImplementedError

    if max(map(len,output_data)) == 0:
        print map(len,output_data)
        continue
    
    golden = sort_tile( input_data, output_data , width, length)
    comparison = True
    for c_output,c_golden in zip(output_data,golden):
        comparison = comparison and ( c_output == list(c_golden[:len(c_output)]) )
        if not comparison:
            print "PROBLEM IN COMPARISON"
            print_run(input_data,output_data,golden)
            pdb.set_trace()
            
    print comparison 
