library verilog;
use verilog.vl_types.all;
entity alu is
    generic(
        COLUMN_WIDTH    : integer := 32;
        OP              : integer := 0;
        \CONSTANT\      : integer := 2
    );
    port(
        col_1_i         : in     vl_logic_vector;
        valid_1_i       : in     vl_logic;
        ready_1_o       : out    vl_logic;
        done_1_i        : in     vl_logic;
        srt_pck_1_i     : in     vl_logic;
        end_pck_1_i     : in     vl_logic;
        col_2_i         : in     vl_logic_vector;
        valid_2_i       : in     vl_logic;
        ready_2_o       : out    vl_logic;
        done_2_i        : in     vl_logic;
        srt_pck_2_i     : in     vl_logic;
        end_pck_2_i     : in     vl_logic;
        conf            : in     vl_logic_vector;
        write           : in     vl_logic;
        chipselect      : in     vl_logic;
        address         : in     vl_logic;
        col_o           : out    vl_logic_vector;
        valid_o         : out    vl_logic;
        ready_i         : in     vl_logic;
        done_o          : out    vl_logic;
        srt_pck_o       : out    vl_logic;
        end_pck_o       : out    vl_logic;
        clk             : in     vl_logic;
        reset_i         : in     vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of COLUMN_WIDTH : constant is 1;
    attribute mti_svvh_generic_type of OP : constant is 1;
    attribute mti_svvh_generic_type of \CONSTANT\ : constant is 1;
end alu;
