//this is to implement unsigned modulo
`define MASK 32'h000000FF

module sort_tile_tb #(
					  parameter COLUMN_WIDTH	= 32,
					  parameter CTRL_WIDTH		= 2,
					  parameter SEED			= 0,
					  //all thresholds are probabilities out of 10
					  parameter SEND_THRESHOLD	= 5,
					  parameter READY_THRESHOLD = 4,
					  parameter DK_THRESHOLD	= 2, 
					  parameter SWAP_THRESHOLD	= 5,
					  parameter END				= 1000,
					  parameter TOP_ROW			= 1
					  );


// logic  valid_1_i,valid_1_o;

// logic  done_1_i;
// logic  done_1_o;

// logic  srt_pck_1_i;
// logic  srt_pck_1_o;

// logic  end_pck_1_i;
// logic  end_pck_1_o;

// logic  ready_1_i,ready_1_o;

// logic [COLUMN_WIDTH-1:0] col_1_i,col_1_o;

// logic [CTRL_WIDTH-1:0] col_2_i,col_2_o;
// logic  ready_2_i,ready_2_o;
// logic  valid_2_i,valid_2_o;

AvalonLink ava_in();
AvalonLink ava_out();
CtrLink   ctrl_in();
CtrLink   ctrl_out();

logic clk, reset;
int seed;

sort_tile u0 (
			  .ava_in(ava_in.Sink),
			  .ava_out(ava_out.Source),
			  .ctrl_in(ctrl_in),
			  .ctrl_out(ctrl_out),
			  .clk(clk),
			  .reset_i(reset),
			  .*
			  );

   always begin
	  #5 clk = !clk;
   end


   initial begin
	  //$monitor ("time: %0t ,col_1_i=%d,col_2_1=%d,col_o=%d,valid_1_i=%b,valid_2_i=%b,valid_o=%b", $time, col_1_i,col_2_i, col_o,valid_1_i,valid_2_i , valid_o);
	  clk				= 0;
	  reset				= 0;
	  seed				= SEED;     //seed parameter for $random has to be a register

	  //if unchanged this is DK ctrl always available
	  ctrl_in.ctrl			= 2'b00; 
	  ctrl_in.valid      	= 1'b1;
	  
	  #5 reset			= 1;
	  #15 reset			= 0;
	  #END $finish;
	  
   end // initial begin
   
   always_ff @(posedge clk) begin
			  
	  if ( reset ) begin
		 ava_in.data    <= 0;
		 ctrl_in.ctrl        <= 0;
		 ava_in.valid   <= 0;
		 if (TOP_ROW)
		   ctrl_in.valid	<= 1;
		 else
		   ctrl_in.ctrl 	<= 0;
		 
		 ava_out.ready  <= 0;
		 ctrl_out.ready		<= 0;
	  end				 
	  else begin
		 
		 if ( ava_in.valid )
		   $display("TIME: %0t SENT 1 %d", $time,$signed(ava_in.data));
		 
		 //this is the ctrl command which is interesting only if the tile is not a slave
		 if ( ctrl_in.valid && !TOP_ROW )  
		   $display("TIME: %0t SENT 2 %b", $time,ctrl_in.ctrl);
		 
		 if ( ava_out.valid ) 
		   $display("TIME: %0t RECEIVED 3 %d", $time,$signed(ava_out.data));
		 
		 ava_in.data		<= ( $random(seed) & `MASK ) ;											   
		 if ( !TOP_ROW )
		   ctrl_in.ctrl		<=  { ($random(seed) % 10) >= SWAP_THRESHOLD , ($random(seed) % 10) >= DK_THRESHOLD};
		 

		 //randomly inject numbers in the sorter
		 ava_in.valid		<=  ( ava_in.ready && ($random(seed) % 10) >= SEND_THRESHOLD )					? 1'b1 : 1'b0;
		 //randomly inject cmds in the sorter
		 if ( !TOP_ROW )
		   ctrl_in.valid		<=  ( ctrl_in.ready && ($random(seed) % 10) >= SEND_THRESHOLD )					? 1'b1 : 1'b0;

         //this comes from the next tile in the conveyor - first term makes ready stable until data is received
		 ava_out.ready		<=  (!ava_out.valid & ava_out.ready) | (($random(seed) % 10) >= READY_THRESHOLD)	? 1'b1 : 1'b0;
		 //this comes from the slave tile
		 ctrl_out.ready		<=  (!ctrl_out.valid & ctrl_out.ready) | (($random(seed) % 10) >= READY_THRESHOLD)	? 1'b1 : 1'b0;
	  end
	  
   end // always_ff @


endmodule