//`include "interfaces.sv"

module sort_row #(
				  parameter COLUMN_WIDTH = 32,
				  parameter CTRL_WIDTH   = 2,
				  parameter LENGTH       = 2,
				  parameter TOP_ROW      = 1,
				  parameter BOTTOM_ROW   = 0
				  )

   (
	//data in conveyor
	AvalonLink.Sink ava_in,
	// input logic [COLUMN_WIDTH-1:0] 	col_1_i, 
	// input logic 					valid_1_i, 
	// output logic 					ready_1_o, 
	// input logic 					done_1_i, 
	// input logic 					srt_pck_1_i, 
	// input logic 					end_pck_1_i, 
		         												   
	//data		 out conveyor
	AvalonLink.Source ava_out,
	// output logic [COLUMN_WIDTH-1:0] col_1_o, 
	// output logic 					valid_1_o, 
	// input logic 					ready_1_i, 
	// output logic 					done_1_o, 
	// output logic 					srt_pck_1_o, 
	// output logic 					end_pck_1_o, 
		         												   
	//ctrl		 in				
	CtrLink ctrl_in[LENGTH],
	// input logic [CTRL_WIDTH-1:0] 	col_2_i [LENGTH], 
	// input logic 					valid_2_i[LENGTH], 
	// output logic 					ready_2_o[LENGTH],
	
	CtrLink ctrl_out[LENGTH], 				  	
	// output logic [CTRL_WIDTH-1:0] 	col_2_o [LENGTH],
	// output logic 					valid_2_o[LENGTH], 
	// input logic 					ready_2_i[LENGTH], 
		         												   
	/*			 std signals */									   	   
	input logic 					clk, 
	input logic 					reset_i // reset everything

	);

   //wires to connect the conveyor
   AvalonLink links[LENGTH-1]();
   
   // logic [COLUMN_WIDTH-1:0] 		conveyor_data[LENGTH-1];
   // logic 							conveyor_valid[LENGTH-1];
   // logic 							conveyor_ready[LENGTH-1];
   // logic 							conveyor_done[LENGTH-1];
   // logic 							conveyor_srt_pck[LENGTH-1];
   // logic 							conveyor_end_pck[LENGTH-1];

   initial begin
	  $display("%m TOP ROW: %d BOTTOM ROW: %d",TOP_ROW,BOTTOM_ROW);
	  
   end
		 
   genvar 							n;		
   generate
	  for ( n = 0 ; n < LENGTH ; n = n+1 ) begin: gen_sort_tiles
		 case ( n )
		   0: sort_tile #(.NSWAPS(LENGTH),
						  .TOP_ROW(TOP_ROW),
						  .BOTTOM_ROW(BOTTOM_ROW)
						  ) u(
											 .ava_in(ava_in),
											 .ctrl_in(ctrl_in[n]),
											 .ctrl_out(ctrl_out[n]),
		   									 // .col_2_i(col_2_i[n]),
		   									 // .valid_2_i(valid_2_i[n]),
		   									 // .ready_2_o(ready_2_o[n]),
						  
		   									 // .col_2_o(col_2_o[n]),
		   									 // .valid_2_o(valid_2_o[n]),
		   									 // .ready_2_i(ready_2_i[n]),

											 .ava_out(links[n].Source),
		   									 // .col_1_o(conveyor_data[n]),
		   									 // .valid_1_o(conveyor_valid[n]), 
		   									 // .ready_1_i(conveyor_ready[n]),
		   									 // .done_1_o(conveyor_done[n])  ,
		   									 // .srt_pck_1_o(conveyor_srt_pck[n]),
		   									 // .end_pck_1_o(conveyor_end_pck[n]),
		   									 .*
		   									 );
		   
		   LENGTH-1: sort_tile #(.NSWAPS(LENGTH),
								 .TOP_ROW(TOP_ROW),
								 .BOTTOM_ROW(BOTTOM_ROW)
								 ) u(
													.ava_in(links[n-1].Sink),
													
													.ctrl_in(ctrl_in[n]),
													.ctrl_out(ctrl_out[n]),
		   				  							// .col_1_i(conveyor_data[n-1]),
		   											// .valid_1_i(conveyor_valid[n-1]), 
		   											// .ready_1_o(conveyor_ready[n-1]),
		   											// .done_1_i(conveyor_done[n-1])  ,
		   											// .srt_pck_1_i(conveyor_srt_pck[n-1]),
		   											// .end_pck_1_i(conveyor_end_pck[n-1]),
													
		   											// .col_2_i(col_2_i[n]),
		   											// .valid_2_i(valid_2_i[n]),
		   											// .ready_2_o(ready_2_o[n]),
													
		   											// .col_2_o(col_2_o[n]),
		   											// .valid_2_o(valid_2_o[n]),
		   											// .ready_2_i(ready_2_i[n]),

													.ava_out(ava_out),
		   											.*
		   						 );
		   default: 
			 sort_tile #(.NSWAPS(LENGTH),
						 .TOP_ROW(TOP_ROW),
						 .BOTTOM_ROW(BOTTOM_ROW)
						 ) u(
											.ava_in(links[n-1].Sink),
											// .col_1_i(conveyor_data[n-1]),
											// .valid_1_i(conveyor_valid[n-1]), 
											// .ready_1_o(conveyor_ready[n-1]),
											// .done_1_i(conveyor_done[n-1])  ,
											// .srt_pck_1_i(conveyor_srt_pck[n-1]),
											// .end_pck_1_i(conveyor_end_pck[n-1]),
											 .ctrl_in(ctrl_in[n]),
											 .ctrl_out(ctrl_out[n]),
								
											// .col_2_i(col_2_i[n]),
											// .valid_2_i(valid_2_i[n]),
											// .ready_2_o(ready_2_o[n]),
											
											// .col_2_o(col_2_o[n]),
											// .valid_2_o(valid_2_o[n]),
											// .ready_2_i(ready_2_i[n]),

											.ava_out(links[n].Source),
											// .col_1_o(conveyor_data[n]),
											// .valid_1_o(conveyor_valid[n]), 
											// .ready_1_i(conveyor_ready[n]),
											// .done_1_o(conveyor_done[n])  ,
											// .srt_pck_1_o(conveyor_srt_pck[n]),
											// .end_pck_1_o(conveyor_end_pck[n]),
		
											.clk(clk),
											.reset_i(reset_i)
						 );
		   endcase
	  end
   endgenerate
   
   
endmodule