
module sort_mesh_wrapper #(
						   parameter COLUMN_WIDTH = 32,
						   parameter WIDTH        = 4,
						   parameter LENGTH    = 31
						)
   
   (

input logic  asi_in1_endofpacket,
input logic  asi_in1_valid,
input logic  asi_in1_error,
output logic  asi_in1_ready,
input logic [COLUMN_WIDTH-1:0] asi_in1_data,
input logic  asi_in1_startofpacket,
input logic  asi_in2_endofpacket,
input logic  asi_in2_valid,
input logic  asi_in2_error,
output logic  asi_in2_ready,
input logic [COLUMN_WIDTH-1:0] asi_in2_data,
input logic  asi_in2_startofpacket,
input logic  asi_in3_endofpacket,
input logic  asi_in3_valid,
input logic  asi_in3_error,
output logic  asi_in3_ready,
input logic [COLUMN_WIDTH-1:0] asi_in3_data,
input logic  asi_in3_startofpacket,
input logic  asi_in4_endofpacket,
input logic  asi_in4_valid,
input logic  asi_in4_error,
output logic  asi_in4_ready,
input logic [COLUMN_WIDTH-1:0] asi_in4_data,
input logic  asi_in4_startofpacket,
output logic  aso_out1_endofpacket,
output logic  aso_out1_valid,
output logic  aso_out1_error,
input logic  aso_out1_ready,
output logic [COLUMN_WIDTH-1:0] aso_out1_data,
output logic  aso_out1_startofpacket,
output logic  aso_out2_endofpacket,
output logic  aso_out2_valid,
output logic  aso_out2_error,
input logic  aso_out2_ready,
output logic [COLUMN_WIDTH-1:0] aso_out2_data,
output logic  aso_out2_startofpacket,
output logic  aso_out3_endofpacket,
output logic  aso_out3_valid,
output logic  aso_out3_error,
input logic  aso_out3_ready,
output logic [COLUMN_WIDTH-1:0] aso_out3_data,
output logic  aso_out3_startofpacket,
output logic  aso_out4_endofpacket,
output logic  aso_out4_valid,
output logic  aso_out4_error,
input logic  aso_out4_ready,
output logic [COLUMN_WIDTH-1:0] aso_out4_data,
output logic  aso_out4_startofpacket,
	/* std signals */
 input logic 					 clk,
 input logic 					 rsi_reset
	);
   
   AvalonLink in[WIDTH]();
   AvalonLink out[WIDTH]();
assign in[0].end_pck = asi_in1_endofpacket;
assign in[0].valid = asi_in1_valid;
assign in[0].done = asi_in1_error;
assign asi_in1_ready = in[0].ready;
assign in[0].data = asi_in1_data;
assign in[0].srt_pck = asi_in1_startofpacket;

assign in[1].end_pck = asi_in2_endofpacket;
assign in[1].valid = asi_in2_valid;
assign in[1].done = asi_in2_error;
assign asi_in2_ready = in[1].ready;
assign in[1].data = asi_in2_data;
assign in[1].srt_pck = asi_in2_startofpacket;

assign in[2].end_pck = asi_in3_endofpacket;
assign in[2].valid = asi_in3_valid;
assign in[2].done = asi_in3_error;
assign asi_in3_ready = in[2].ready;
assign in[2].data = asi_in3_data;
assign in[2].srt_pck = asi_in3_startofpacket;

assign in[3].end_pck = asi_in4_endofpacket;
assign in[3].valid = asi_in4_valid;
assign in[3].done = asi_in4_error;
assign asi_in4_ready = in[3].ready;
assign in[3].data = asi_in4_data;
assign in[3].srt_pck = asi_in4_startofpacket;

assign aso_out1_endofpacket = out[0].end_pck;
assign aso_out1_valid = out[0].valid;
assign aso_out1_error = out[0].done;
assign out[0].ready = aso_out1_ready;
assign aso_out1_data = out[0].data;
assign aso_out1_startofpacket = out[0].srt_pck;

assign aso_out2_endofpacket = out[1].end_pck;
assign aso_out2_valid = out[1].valid;
assign aso_out2_error = out[1].done;
assign out[1].ready = aso_out2_ready;
assign aso_out2_data = out[1].data;
assign aso_out2_startofpacket = out[1].srt_pck;

assign aso_out3_endofpacket = out[2].end_pck;
assign aso_out3_valid = out[2].valid;
assign aso_out3_error = out[2].done;
assign out[2].ready = aso_out3_ready;
assign aso_out3_data = out[2].data;
assign aso_out3_startofpacket = out[2].srt_pck;

assign aso_out4_endofpacket = out[3].end_pck;
assign aso_out4_valid = out[3].valid;
assign aso_out4_error = out[3].done;
assign out[3].ready = aso_out4_ready;
assign aso_out4_data = out[3].data;
assign aso_out4_startofpacket = out[3].srt_pck;


      sort_mesh #(.WIDTH(WIDTH),.LENGTH(LENGTH)) s(
								   .ava_in(in),
								   .ava_out(out),
								   .reset_i(rsi_reset),
								   .clk(clk)
								   );   
endmodule