module sort_mesh #(
				  parameter COLUMN_WIDTH = 32,
				  parameter CTRL_WIDTH   = 2,
				  parameter LENGTH       = 2,
				  parameter WIDTH        = 2
				  )

   (
	//data in conveyors
	AvalonLink.Sink ava_in[WIDTH],
	//data	out conveyors
	AvalonLink.Source ava_out[WIDTH],
	
	// input logic [COLUMN_WIDTH-1:0] 	col_1_i[WIDTH], 
	// input logic 					valid_1_i[WIDTH], 
	// output logic 					ready_1_o[WIDTH], 
	// input logic 					done_1_i[WIDTH], 
	// input logic 					srt_pck_1_i[WIDTH], 
	// input logic 					end_pck_1_i[WIDTH], 
		         												   
	//data	out conveyor
	// output logic [COLUMN_WIDTH-1:0] col_1_o[WIDTH], 
	// output logic 					valid_1_o[WIDTH], 
	// input logic 					ready_1_i[WIDTH], 
	// output logic 					done_1_o[WIDTH], 
	// output logic 					srt_pck_1_o[WIDTH], 
	// output logic 					end_pck_1_o[WIDTH], 
		         												   
	/*			 std signals */									   	   
	input logic 					clk, 
	input logic 					reset_i // reset everything

	);

   int 								i,j;
   genvar 							n,m;		

   //wires to connect the rows
   CtrLink links[WIDTH+1][LENGTH]();

   //these are not connected!?
   // initial begin
   // 	  for ( i = 1 ; i < LENGTH ; i = i+1 ) begin
   // 		 links[0][i].valid = 1'b1;
   // 		 links[0][i].ctrl  = 2'b00;
   // 	  end
   // end
   
   
   generate
	  for ( n = 1 ; n <= WIDTH ; n = n+1 ) begin: gen_sort_rows
		 sort_row #(.TOP_ROW(n==1),.BOTTOM_ROW(n==WIDTH),.LENGTH(LENGTH)) u(
					.ava_in(ava_in[n-1]),
					.ava_out(ava_out[n-1]),
					.ctrl_in(links[n-1]),
					.ctrl_out(links[n]),
		   			.*
	   				);
	  end
   endgenerate
   
endmodule