/* equi-join */

/* Working */
module joiner #(
				parameter COLUMN_WIDTH = 32,
				parameter OP = 2
				)

   (
//*  DATA IN */
	
	//data in AvalonST - parent column
	input logic [COLUMN_WIDTH-1:0] 	col_1_i,
	input logic 					valid_1_i,
	output logic 					ready_1_o,
	input logic 					done_1_i,
	input logic 					srt_pck_1_i,
	input logic 					end_pck_1_i,
	
	//data in AvalosST - child_column
	input logic [COLUMN_WIDTH-1:0] 	col_2_i,
	input logic 					valid_2_i,
	output logic 					ready_2_o,
	input logic 					done_2_i,
	input logic 					srt_pck_2_i,
	input logic 					end_pck_2_i,

	//data in AvalonST - payload column 1
	input logic [COLUMN_WIDTH-1:0] 	col_3_i,
	input logic 					valid_3_i,
	output logic 					ready_3_o,
	input logic 					done_3_i,
	input logic 					srt_pck_3_i,
	input logic 					end_pck_3_i,
	
	//data in AvalosST - payload column 2
	input logic [COLUMN_WIDTH-1:0] 	col_4_i,
	input logic 					valid_4_i,
	output logic 					ready_4_o,
	input logic 					done_4_i,
	input logic 					srt_pck_4_i,
	input logic 					end_pck_4_i,

//*  DATA OUT */
	
	//data out AvalonST - parent column
	output logic [COLUMN_WIDTH-1:0] col_1_o,
	output logic 					valid_1_o,
	input logic 					ready_1_i,
	output logic 					done_1_o,
	output logic 					srt_pck_1_o,
	output logic 					end_pck_1_o,
	
	//data out AvalosST - child_column
	output logic [COLUMN_WIDTH-1:0] col_2_o,
	output logic 					valid_2_o,
	input logic 					ready_2_i,
	output logic 					done_2_o,
	output logic 					srt_pck_2_o,
	output logic 					end_pck_2_o,

	//data out AvalonST - payload column 1
	output logic [COLUMN_WIDTH-1:0] col_3_o,
	output logic 					valid_3_o,
	input logic 					ready_3_i,
	output logic 					done_3_o,
	output logic 					srt_pck_3_o,
	output logic 					end_pck_3_o,
	
	//data out AvalosST - payload column 2
	output logic [COLUMN_WIDTH-1:0] col_4_o,
	output logic 					valid_4_o,
	input logic 					ready_4_i,
	output logic 					done_4_o,
	output logic 					srt_pck_4_o,
	output logic 					end_pck_4_o,

//* AVALON MM CONFIGURATION OF COLUMN BITS */
	input logic [COLUMN_WIDTH-1:0] 	conf,
	input logic 					write,
	input logic 					chipselect,
	//input logic 					address,

	/* std signals */
	input logic 					clk,
	input logic 					reset_i // reset everything
	);

   //from INPUT BUFFERS to TILE
   logic [COLUMN_WIDTH-1:0] 		col1,col2,col3,col4; 
   logic 							valid1,valid2,valid3,valid4;
   logic 							done1,done2,done3,done4;
   //from TILE to INPUT BUFFERS
   logic 							ready1,ready2,ready3,ready4;

   logic 							was_rdy;
   logic 							inputs_valid,inputs_done;   
   logic 							outputs_valid;
   logic 							shift_parent,shift_child;
   
   /**
	op is a bitmask which specifies for each payload column to which table they belong:
	e.g. op[0] == 0 => payload column 0 belongs to parent column
	*/
   logic [1:0] 						op;

   
   //genvar 							n;
   
   // generate
   // 	  for ( n = 0 ; n < 4 ; n = n + 1 ) begin : BUFFER
   // 		 buffer in(.col_i(col_n_i), 
   // 					.valid_i(valid_n_i), 
   // 					.ready_i(readyn),
   // 					.col_o(coln),
   // 					.valid_o(validn),  
   // 					.ready_o(ready_n_o),
   // 					.clk(clk),
   // 					.reset_i(reset_i),
   // 					.start_pck_in(srt_pck_n_i),
   // 					.end_pck_in(end_pck_n_i),
   // 					.done_i(done_n_i),
   // 					.done_o(donen)
   // 					);
		 
   // 	  end
   // end
   
   buffer in1(.col_i(col_1_i), 
			  .valid_i(valid_1_i), 
			  .ready_i(ready1),
              .col_o(col1),
			  .valid_o(valid1),  
			  .ready_o(ready_1_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_1_i),
			  .end_pck_in(end_pck_1_i),
			  .done_i(done_1_i),
			  .done_o(done1)
			  );

   buffer in2(.col_i(col_2_i), 
			  .valid_i(valid_2_i), 
			  .ready_i(ready2),
              .col_o(col2),
			  .valid_o(valid2),  
			  .ready_o(ready_2_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_2_i),
			  .end_pck_in(end_pck_2_i),
			  .done_i(done_2_i),
			  .done_o(done2)
			  );
   
   buffer in3(.col_i(col_3_i), 
			  .valid_i(valid_3_i), 
			  .ready_i(ready3),
              .col_o(col3),
			  .valid_o(valid3),  
			  .ready_o(ready_3_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_3_i),
			  .end_pck_in(end_pck_3_i),
			  .done_i(done_3_i),
			  .done_o(done3)
			  );
   
   buffer in4(.col_i(col_4_i), 
			  .valid_i(valid_4_i), 
			  .ready_i(ready4),
              .col_o(col4),
			  .valid_o(valid4),  
			  .ready_o(ready_4_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_4_i),
			  .end_pck_in(end_pck_4_i),
			  .done_i(done_4_i),
			  .done_o(done4)
			  );

   assign srt_pck_1_o = 1'b1;
   assign end_pck_1_o = 1'b1;
   assign srt_pck_2_o = 1'b1;
   assign end_pck_2_o = 1'b1;
   assign srt_pck_3_o = 1'b1;
   assign end_pck_3_o = 1'b1;
   assign srt_pck_4_o = 1'b1;
   assign end_pck_4_o = 1'b1;

   assign inputs_valid = valid1 & valid2 & valid3 & valid4;
   assign inputs_done  = done1 & done2 & done3 & done4;

   assign ready1 = shift_parent;
   assign ready2 = shift_child;
   
   //this is a little wierd -> you got to decide the endianness of this operation
   //op is little endian
   assign ready3 = ( op[0] == 1'b0 ) ? shift_parent : shift_child;
   assign ready4 = ( op[1] == 1'b0 ) ? shift_parent : shift_child;

   //output valid
   assign valid_1_o = outputs_valid;
   assign valid_2_o = outputs_valid;
   assign valid_3_o = outputs_valid;
   assign valid_4_o = outputs_valid;
   //output done
   assign done_1_o = inputs_done;
   assign done_2_o = inputs_done;
   assign done_3_o = inputs_done;
   assign done_4_o = inputs_done;
	 
   //data output
   assign col_1_o = col1;
   assign col_2_o = col2;
   assign col_3_o = col3;
   assign col_4_o = col4;
   
   always_comb begin
	  shift_parent = 0;
	  shift_child  = 0;
	  outputs_valid = 0;
	  
	  if ( was_rdy && inputs_valid )  begin
		 //consume all done packets and output a new_one
		 if ( inputs_done ) begin
			outputs_valid = 1;
			shift_parent  = 1;
			shift_child   = 1;			
		 end
		 else begin
			//shift logic for the join
			if ( col1 < col2 ) begin
			   shift_parent = 1;
			end
			else begin
			   if ( col1 == col2 ) begin
				  outputs_valid = 1;
			   end
			   shift_child = 1;
			end
		 end
	  end 
   end


   always_ff @(posedge clk) begin
      if(~reset_i) begin
		 if(chipselect && write) begin
			op <= conf[1:0];
		 end

		 was_rdy <= ready_1_i & ready_2_i & ready_3_i & ready_4_i;
	  end
	  else begin
		 op				<= OP;
		 was_rdy		<= 0;
	  end
   end

endmodule
