`define MAX_INT 10000

module join_tb #(
				 parameter COLUMN_WIDTH = 32,
				 parameter SEED = 0,
				 parameter SEND_THRESHOLD = 5,
				 parameter READY_THRESHOLD = 4,
				 parameter INCR = 3,
				 parameter END = 2000
				);

logic  valid_1_i,valid_2_i,valid_3_i,valid_4_i;

logic  valid_1_o,valid_2_o,valid_3_o,valid_4_o;

logic  done_1_i,done_2_i,done_3_i,done_4_i;

logic  done_1_o,done_2_o,done_3_o,done_4_o;

logic  srt_pck_1_i,srt_pck_2_i,srt_pck_3_i,srt_pck_4_i;

logic  srt_pck_1_o,srt_pck_2_o,srt_pck_3_o,srt_pck_4_o;

logic  end_pck_1_i,end_pck_2_i,end_pck_3_i,end_pck_4_i;

logic  end_pck_1_o,end_pck_2_o,end_pck_3_o,end_pck_4_o;

logic  ready_1_i,ready_2_i,ready_3_i,ready_4_i;

logic  ready_1_o,ready_2_o,ready_3_o,ready_4_o;

logic [COLUMN_WIDTH-1:0] col_1_i,col_2_i,col_3_i,col_4_i;

logic [COLUMN_WIDTH-1:0] col_1_o,col_2_o,col_3_o,col_4_o;


logic clk, reset;
logic [COLUMN_WIDTH-1:0] conf;
logic write,chipselect;
int seed;

logic valid1,valid2,valid3,valid4;

//logic was_rdy1,was_rdy2,was_rdy3,was_rdy4;
// class PrimaryColumn #(parameter int ZERO_WEIGHT = 1, int MAX_INCR = 4);
//    rand bit valid;
//    rand int incr;
   
//    constraint valid_dist { 
// 	  valid dist{
// 				   0 := ZERO_WEIGHT,
// 				   1 := 1
// 				   };
//    }

//    constraint max_incr { 
// 	  if (valid == 1)
// 	 incr inside {[1:MAX_INCR]}; 
// 	  else
// 	 incr == 0;
//    }
// endclass: PrimaryColumn; // PrimaryColumn

// class ForeignColumn #(parameter int ZERO_WEIGHT = 0, int MAX_INCR = 4);
//    rand bit valid;
//    rand int incr;
   
//    constraint valid_dist { 
// 	  valid dist{
// 				   0 := ZERO_WEIGHT,
// 				   1 := 1
// 				   };
//    }
//    constraint max_incr {
// 	  if (valid == 1)
// 	 incr inside {[0:MAX_INCR]};
// 	  else
// 	 incr == 0;
//    }
// //how should this mix with the previous constrain?
//    constraint incr_dist {
// 	  incr dist{
// 				 0 := 1,
// 				 [1:MAX_INCR] :/ 1
// 				};
//    }
	 
// endclass: ForeignColumn;

// PrimaryColumn #(.MAX_INCR(10)) p = new;
// ForeignColumn #(.MAX_INCR(2)) f = new;

joiner u0 (
		   .clk(clk),
		   .reset_i(reset),
		   .*
		   );

   always begin
	  #5 clk = !clk;
   end
   
   initial begin
	  //$monitor ("time: %0t ,col_1_i=%d,col_2_1=%d,col_o=%d,valid_1_i=%b,valid_2_i=%b,valid_o=%b", $time, col_1_i,col_2_i, col_o,valid_1_i,valid_2_i , valid_o);
	  clk = 0;
	  reset = 0;
	  chipselect = 0;
	  seed = SEED;   //seed parameter for $random has to be a register
	  		
	  #5 reset = 1;
	  #15 reset = 0;
	  #END $finish;
	  
   end // initial begin

always @(posedge clk) begin
   valid1 =  ( ready_1_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;
   valid2 =  ( ready_2_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;
   valid3 =  ( ready_3_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;
   valid4 =  ( ready_4_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;   
end
   
   always_ff @(posedge clk) begin

	  // input_1    = ( $random % `MAX_INT);
	  // input_2    = ( $random % `MAX_INT);
	  
	  if ( reset ) begin
		 // was_rdy1  <= 0;
		 // was_rdy2  <= 0;
		 // was_rdy3  <= 0;
		 // was_rdy4  <= 0;
		 
		 col_1_i   <= 0;
		 col_2_i   <= 0;
		 col_3_i   <= 0;
		 col_4_i   <= 0;
		 
		 valid_1_i <= 0;
		 valid_2_i <= 0;
		 valid_3_i <= 0;
		 valid_4_i <= 0;

		 ready_1_i   <= 0;
		 ready_2_i   <= 0;
		 ready_3_i   <= 0;
		 ready_4_i   <= 0;
	  end				 
	  else begin
		 
		 if ( valid_1_i )
		   $display("TIME: %0t SENT 1 %d", $time,$signed(col_1_i));
		 if ( valid_2_i )
		   $display("TIME: %0t SENT 2 %d", $time,$signed(col_2_i));
		 if ( valid_3_i )
		   $display("TIME: %0t SENT 3 %d", $time,$signed(col_3_i));
		 if ( valid_4_i )
		   $display("TIME: %0t SENT 4 %d", $time,$signed(col_4_i));

		 if ( valid_1_o ) 
			$display("TIME: %0t RECEIVED 5 %d", $time,$signed(col_1_o));
		 if ( valid_2_o ) 
			$display("TIME: %0t RECEIVED 6 %d", $time,$signed(col_2_o));
		 if ( valid_3_o ) 
			$display("TIME: %0t RECEIVED 7 %d", $time,$signed(col_3_o));
		 if ( valid_4_o ) 
			$display("TIME: %0t RECEIVED 8 %d", $time,$signed(col_4_o));

		 // p.randomize();
		 // f.randomize();
		   
		 // //first input is sorted
		 // //assert(std::randomize(incr));
		 // col_1_i   <=  ( col_1_i + p.incr) ;
		 // //second input is sorted and might have repetition
		 // col_2_i   <=  ( col_2_i + f.incr) ;
		 // //payload inputs whatever

		 // valid_1_i <=  p.valid;
		 // valid_2_i <=  f.valid;
		 // valid_3_i <=  ( ready_2_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;
		 // valid_4_i <=  ( ready_2_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;
		
		 valid_1_i <= valid1;
		 valid_2_i <= valid2;
		 valid_3_i <= valid3;
		 valid_4_i <= valid4;

		 col_1_i <= ( valid1 ) ? col_1_i + (($random(seed) % INCR) + 1) : col_1_i;
		 col_2_i <= ( valid2 ) ? col_2_i + $random(seed) % INCR : col_2_i;
		 col_3_i <=  ( $random(seed) % `MAX_INT) ;											   
		 col_4_i <=  ( $random(seed) % `MAX_INT) ;

		 //the first term accounts for the fact that ready does not jump around
		 //it stays stable until an element is received
		 ready_1_i   <= (!valid_1_o & ready_1_i) | ( (($random(seed) % 10) >= READY_THRESHOLD) ? 1'b1 : 1'b0 );
		 ready_2_i   <= (!valid_2_o & ready_2_i) | ( (($random(seed) % 10) >= READY_THRESHOLD) ? 1'b1 : 1'b0 );
		 ready_3_i   <= (!valid_3_o & ready_3_i) | ( (($random(seed) % 10) >= READY_THRESHOLD) ? 1'b1 : 1'b0 );
		 ready_4_i   <= (!valid_4_o & ready_4_i) | ( (($random(seed) % 10) >= READY_THRESHOLD) ? 1'b1 : 1'b0 );
		 
	  end
	  
   end // always_ff @
   
endmodule