/* colfilter */

/* Working */
module colfilter #(
			 parameter COLUMN_WIDTH = 32
			 )

   (
	//data in AvalonST
	input logic [COLUMN_WIDTH-1:0] 	col_1_i,
	input logic 					valid_1_i,
	output logic 					ready_1_o,
	input logic 					done_1_i,
	input logic 					srt_pck_1_i,
	input logic 					end_pck_1_i,
	
	//data in AvalosST
	input logic [COLUMN_WIDTH-1:0] 	col_2_i,
	input logic 					valid_2_i,
	output logic 					ready_2_o,
	input logic 					done_2_i,
	input logic 					srt_pck_2_i,
	input logic 					end_pck_2_i,
   
	//data out AvalonST
	output logic [COLUMN_WIDTH-1:0] col_o, 
	output logic 					valid_o,
	input logic 					ready_i,
	output logic 					done_o, 
	output logic 					srt_pck_o,
	output logic 					end_pck_o,

	/* std signals */
	input logic 					clk,
	input logic 					reset_i // reset everything
	);

   logic [COLUMN_WIDTH-1:0] 		bool; //out from RS1
   logic [COLUMN_WIDTH-1:0] 		col; // out from RS2
   
   logic 							bool_ready; //ready input to first RS
   logic 							col_ready; //ready input to second RS

   logic 							bool_valid; //out from RS1
   logic 							col_valid; //out from RS2

   logic 							bool_done, col_done;   

   logic 							was_rdy;
   logic 							input_valid, done_output;
   
   
   buffer in1(.col_i(col_1_i), 
			  .valid_i(valid_1_i), 
			  .ready_i(bool_ready),
              .col_o(bool),
			  .valid_o(bool_valid),  
			  .ready_o(ready_1_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_1_i),
			  .end_pck_in(end_pck_1_i),
			  .done_i(done_1_i),
			  .done_o(bool_done)
			  );
   
   buffer in2(.col_i(col_2_i), 
			  .valid_i(valid_2_i), 
			  .ready_i(col_ready),
              .col_o(col),
			  .valid_o(col_valid),  
			  .ready_o(ready_2_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_2_i),
			  .end_pck_in(end_pck_2_i),
			  .done_i(done_2_i),
			  .done_o(col_done)
			  );

   assign srt_pck_o = 1;
   assign end_pck_o = 1;
   
   always_comb begin

	  input_valid    = bool_valid && col_valid;
	  done_output    = bool_done & col_done;

	  //logic is that there must be two valid record with done selected in order for this to work
	  if (was_rdy && input_valid)  begin

		 bool_ready = 1; 
		 col_ready = 1;   
		 
		 valid_o = bool[0] | done_output;	//the packet with the done bit is always valid and has no payload
		 col_o   = col;
		 done_o = done_output;
		 
	  end 
	  else begin
		 done_o  = 0;
		 valid_o = 0;
		 col_o   = 0;
		 bool_ready  = 0;
		 col_ready  = 0; 
	  end // else: !if(was_rdy && input_valid)
	  
	  
	  $display ("COLFILTER COMB time %d was_rdy %b bool: %d bool_valid: %b data: %d valid2 %b valid_o %b", $time,was_rdy,bool,bool_valid,col,col_valid,valid_o);
   end


   always_ff @(posedge clk) begin
      if(~reset_i) begin
		 was_rdy <= ready_i;
	  end
	  else begin
		 was_rdy <= 0;
	  end
   end

endmodule
