module buffer_tb #(
				   parameter COLUMN_WIDTH = 32
				   );

   reg [COLUMN_WIDTH-1:0]data_in;
   wire [COLUMN_WIDTH-1:0] data_out;
   
   logic clk, reset,valid_in,ready_in,ready_out,valid_out,start_pck_in,end_pck_in,done_i,done_o;

   buffer u0 (
			  .col_i(data_in),
			  .valid_i(valid_in),
			  .ready_o(ready_out),
			  .col_o(data_out),
			  .valid_o(valid_out),
			  .ready_i(ready_in),
			  .clk(clk),
			  .reset_i(reset),
			  .*
			  );
   
   initial begin
	  $monitor ("time: %0t clk=%b,reset=%b,data_in=%d,valid_in=%b,data_out=%d,valid_out=%b", $time,clk,reset,data_in,valid_in,data_out,valid_out);
	  clk = 0;
	  reset = 0;
	  data_in = 7;
	  valid_in = 0;
	  #5 reset = 1;
	  // this should be the initial state of everything 
	  // output not valid -ready to take data
	  #15 reset = 0; valid_in = 0; ready_in = 1; 
	  #10 valid_in = 1; data_in =1;
	  #10 valid_in = 0;
	  #10 valid_in = 1; data_in =2;  //EMPTY -> RUNNING
	  #10 ready_in = 0; valid_in = 1; data_in=3;//RUNNING -> BLOCKED
	  #10 ready_in = 1; valid_in = 1; data_in=4;//RUNNING -> RECOVER
	  #10 ready_in = 1; valid_in = 1; data_in=5;//RECOVER -> RECOVER
	  #10 ready_in = 1; valid_in = 0; data_in=6;//RECOVER -> RUNNING
	  #10 ready_in = 1; valid_in = 0; data_in=7;//RECOVER -> EMPTY

	  #10 $finish;
	  
   end // initial begin

   always begin
	  #5 clk = !clk;
   end
endmodule