/* Working */
module buffer_ctrl #(
			   parameter CTRL_WIDTH = 2
			   )

   (
	//data in AvalonST
	input logic [CTRL_WIDTH-1:0]  col_i,
	input logic 				  valid_i,
	output logic 				  ready_o,
	// input logic 					start_pck_in,  //ignored because ctrl
	// input logic 					end_pck_in,    //
	// input logic 					done_i,        //
   
	//data out [ to tile logic ]
	output logic [CTRL_WIDTH-1:0] col_o,
	output logic 				  valid_o,
	input logic 				  ready_i,
	// output logic 					start_pck_out, //ignored 
	// output logic 					end_pck_out,   //ignored 
	//output logic 					done_o,        // ignored bc ctrl

	/* std signals */
	input logic 				  clk,
	input logic 				  reset_i // reset everything
	);

   logic [CTRL_WIDTH-1:0] 		main;
   logic [CTRL_WIDTH-1:0] 		aux;
   
   logic [2:0] 						state;

   assign col_o  = main;

   assign valid_o = state[0] ^ state[1];
							
   always_comb begin
	  
	  case (state)
		0: begin
		   ready_o = 1;
		end
		1: begin
		   //ready_o = ~ready_i; //bubble gets eaten one clock cycle later in this way	   
		   ready_o = ~(valid_i & ~ready_i); //I thought this was problematic but it isn't
		end
		2: begin
		   ready_o = 0;
		end
		default: begin
		   ready_o = 0;
		end
	  endcase
	  //$display ("\t%m COMB time %d state %d valid_i: %b ready_i %b valid_o: %b ready_o: %b", $time, state, valid_i, ready_i, valid_o, ready_o);

   end 
   
   /* input buffering */
   always_ff @(posedge clk) begin
	  if(reset_i) begin
		 state <= 0;
		 main <= 0;
		 aux <= 0;
	  end
	  else begin
		 case (state)
		   0 : begin           //EMPTY
			 if (valid_i) begin
				main <= col_i;
				state <= 1;
			 end
		   end
		   1 : begin           //MAIN FULL
			 if (valid_i == ready_i) begin
				if (valid_i) begin
				   main <= col_i;
				end
			 end
			 else begin 
				if (ready_i) begin //~V & R
				   state <= 0;
				end
				else begin         //V & ~R 
				   aux <= col_i;
				   state <= 2;
				end
			 end
		   end
		   2 : begin           //AUX FULL
			  if (valid_i) begin
				 if (ready_i) begin
					main <= aux;
					aux <= col_i;
				 end
				 else begin //V & ~R
					//write garbage on the state regs - this should not happen
					main <= 00;
					aux  <= 00;
					$display("BUFFER_CTRL.SV: WRONG");
				 end 
			  end 
			  else begin //~V
				 if (ready_i) begin
					state <= 1;
					main <= aux;
					aux <= 0;  //this is not necessary - just for testing
					//done_aux <= 0;
				 end
				 else begin
					state <= 2; //STALLING
				 end
			  end

		   end
		 endcase // case (state)
		 //$display ("\t%m SEQ time %d state %d valid_i %b ready_i %b main %d aux %d", $time, state, valid_i, ready_i, main, aux);
	  end //!reset
   end    //always_ff
endmodule
