/* boolgen */

/* Working */
module boolgen #(
			 parameter COLUMN_WIDTH = 32
			 )

   (
	//data in AvalonST
	input logic [COLUMN_WIDTH-1:0] 	col_1_i,
	input logic 					valid_1_i,
	output logic 					ready_1_o,
	input logic 					done_1_i,
	input logic 					srt_pck_1_i,
	input logic 					end_pck_1_i,
	
	//data in AvalosST
	input logic [COLUMN_WIDTH-1:0] 	col_2_i,
	input logic 					valid_2_i,
	output logic 					ready_2_o,
	input logic 					done_2_i,
	input logic 					srt_pck_2_i,
	input logic 					end_pck_2_i,
   
	//control in AvalonMM
	input logic [COLUMN_WIDTH-1:0] 	conf,
	input logic 					write,
	input logic 					chipselect,
	input logic 					address,

	//data out AvalonST
	output logic [COLUMN_WIDTH-1:0] col_o, 
	output logic 					valid_o,
	input logic 					ready_i,
	output logic 					done_o, 
	output logic 					srt_pck_o,
	output logic 					end_pck_o,

	/* std signals */
	input logic 					clk,
	input logic 					reset_i // reset everything
	);

   //logic [COLUMN_WIDTH-1:0] 		col_ob; //Module out

   logic [COLUMN_WIDTH-1:0] 		col_1; //out from RS1
   logic [COLUMN_WIDTH-1:0] 		col_2; // out from RS2
   
   logic 							ready1; //ready input to first RS
   logic 							ready2; //ready input to second RS

   logic 							valid1; //out from RS1
   logic 							valid2; //out from RS2

   logic 							done1, done2;   

   logic 							was_rdy;
   logic 							input_valid, done_output;

   /**
	op can be:
	==,!=,<,<=,>=,> between two columns
	same            with a constant sent from the AVALON-MM bus
	
	then we could use the boolgen to detect groups e magari fare anche il case
	*/
   logic [3:0] 						op;
   logic [31:0] 					constant;
   logic [31:0] 					second_operand;
   
   logic 							equal,greater;
   
   
   buffer in1(.col_i(col_1_i), 
			  .valid_i(valid_1_i), 
			  .ready_i(ready1),
              .col_o(col_1),
			  .valid_o(valid1),  
			  .ready_o(ready_1_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_1_i),
			  .end_pck_in(end_pck_1_i),
			  .done_i(done_1_i),
			  .done_o(done1)
			  );
   
   buffer in2(.col_i(col_2_i), 
			  .valid_i(valid_2_i), 
			  .ready_i(ready2),
              .col_o(col_2),
			  .valid_o(valid2),  
			  .ready_o(ready_2_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_2_i),
			  .end_pck_in(end_pck_2_i),
			  .done_i(done_2_i),
			  .done_o(done2)
			  );

   assign srt_pck_o = 1;
   assign end_pck_o = 1;

   assign greater = col_1  > second_operand;
   assign equal   = col_1  == second_operand;

   assign input_valid = ( op <= 4'd8 ) ? (valid1 & valid2) : valid1 ;
   assign done_output = ( op <= 4'd8 ) ? (done1 & done2) : done1 ;
   assign second_operand = ( op <= 4'd8 ) ? col_2 : constant ;
   

   
   always_comb begin

	  valid_o = 0;
	  ready1 = 0;
	  ready2 = 0;
	  done_o = 0;
	  col_o = 0;
	  
	  if (was_rdy && input_valid)  begin
		 
		 valid_o = 1;
		 ready1 = 1; 
		 ready2 = 1;   //In case of operation w constant this will drain the stream coming in input2
		 
		 done_o = done_output;
		 
		 case(op[2:0])
		   
		   //==
		   3'b000:col_o = {31'd0,equal};
		   //!=
		   3'b001:col_o = {31'd0,~equal}; 
		   //<
		   3'b010:col_o = {31'd0,~greater};
		   //<=
		   3'b011:col_o = {31'd0,(~greater | equal)};
		   //>=
		   3'b100:col_o = {31'd0,(greater | equal)};
		   //>
		   3'b101:col_o = {31'd0,greater};
		   
		   default: 
			  $display("Error in selecting boolgen operation");

		 endcase
	  end 
	  // else begin
	  // 	 done_o  = 0;
	  // 	 valid_o = 0;
	  // 	 col_o   = 0;
	  // 	 ready1  = 0;
	  // 	 ready2  = 0; 
		 
	  // end // else: !if(was_rdy && input_valid)
	  
	  
	  // $display ("ALU COMB time %d was_rdy %b col_1: %d valid1: %b ready1: %b col_2: %d valid2 %b valid_o %b", $time,was_rdy,col_1,valid1,ready1,col_2,valid2,valid_o);
   end


   always_ff @(posedge clk) begin

      if(reset_i) begin
		 op       <= 4'b0000;
		 was_rdy  <= 1'b0;
		 constant <= 32'b0;
      end
	  else begin
		 if(chipselect && write) begin
			if (address == 0)
			  op <= conf[3:0];
			else
			  constant <= conf;
		 end
		 was_rdy <= ready_i;
	  end
   end

endmodule
