`define MAX_INT 10000

module alu_tb #(
				parameter COLUMN_WIDTH = 32,
				parameter SEED = 0,
				parameter SEND_THRESHOLD = 5,
				parameter READY_THRESHOLD = 4,
				parameter END = 1000
				);

   logic [COLUMN_WIDTH-1:0] col_1_i;
   logic [COLUMN_WIDTH-1:0] col_2_i;
   logic [COLUMN_WIDTH-1:0] col_o;
   
   logic clk, reset, valid_1_i, valid_2_i, ready_1_o,ready_2_o,valid_o,ready_i;
   logic srt_pck_1_i,end_pck_1_i,srt_pck_2_i,end_pck_2_i,done_1_i,done_2_i,done_o,srt_pck_o,end_pck_o;

logic [COLUMN_WIDTH-1:0]  conf;

logic write,chipselect,address;
   
   logic was_rdy1,was_rdy2,sent_rdy;
   int 	 seed;
   
   
   alu u0 (
		   .clk(clk),
		   .reset_i(reset),
		   .*
		   );

   always begin
	  #5 clk = !clk;
   end
   
   initial begin
	  //$monitor ("time: %0t ,col_1_i=%d,col_2_1=%d,col_o=%d,valid_1_i=%b,valid_2_i=%b,valid_o=%b", $time, col_1_i,col_2_i, col_o,valid_1_i,valid_2_i , valid_o);
	  clk = 0;
	  reset = 0;
	  chipselect = 0;
	  seed = SEED;   //seed parameter for $random has to be a register
	  		
	  #5 reset = 1;
	  #15 reset = 0;
	  #END $finish;
	  
   end // initial begin
   
   always_ff @(posedge clk) begin

	  // input_1    = ( $random % `MAX_INT);
	  // input_2    = ( $random % `MAX_INT);
	  
	  if ( reset ) begin
		 was_rdy1  <= 0;
		 was_rdy2  <= 0;
		 sent_rdy  <= 0;
		 col_1_i   <= 0;
		 col_2_i   <= 0;
		 valid_1_i <= 0;
		 valid_2_i <= 0;
		 ready_i   <= 0;
	  end				 
	  else begin
		 
		 // if ( valid_1_i )
		 //   $display("TIME: %0t SENT 1 %d %d", $time,col_1_i,input_1);
		 // if ( valid_2_i )
		 //   $display("TIME: %0t SENT 2 %d %d", $time,col_2_i,input_2);
		 // if ( valid_o )
		 //   $display("TIME: %0t RECEIVED %d %d", $time,col_o,alu_output);
		 // col_1_i   <=  input_1 ;											   
		 // col_2_i   <=  input_2 ;

		 if ( valid_1_i )
		   $display("TIME: %0t SENT 1 %d", $time,$signed(col_1_i));
		 if ( valid_2_i )
		   $display("TIME: %0t SENT 2 %d", $time,$signed(col_2_i));
		 if ( valid_o ) 
			$display("TIME: %0t RECEIVED 3 %d", $time,$signed(col_o));
		 
		 col_1_i   <=  ( $random(seed) % `MAX_INT) ;											   
		 col_2_i   <=  ( $random(seed) % `MAX_INT) ;

		 was_rdy1  <=  ready_1_o;
		 was_rdy2  <=  ready_2_o;
		 sent_rdy  <=  ready_i;

		 valid_1_i <=  ( ready_1_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;						                                                                                
		 valid_2_i <=  ( ready_2_o && ($random(seed) % 10) >= SEND_THRESHOLD )  ? 1'b1 : 1'b0;						   
		 ready_i   <=  (($random(seed) % 10) >= READY_THRESHOLD) ? 1'b1 : 1'b0;
		 
	  end
	  
   end // always_ff @
   
endmodule