/* alu */

/* Working */
module alu #(
			 parameter COLUMN_WIDTH = 32,
			 parameter OP   = 0,
			 parameter CONSTANT = 2
			 )

   (
	//data in AvalonST
	input logic [COLUMN_WIDTH-1:0] 	col_1_i,
	input logic 					valid_1_i,
	output logic 					ready_1_o,
	input logic 					done_1_i,
	input logic 					srt_pck_1_i,
	input logic 					end_pck_1_i,
	
	//data in AvalosST
	input logic [COLUMN_WIDTH-1:0] 	col_2_i,
	input logic 					valid_2_i,
	output logic 					ready_2_o,
	input logic 					done_2_i,
	input logic 					srt_pck_2_i,
	input logic 					end_pck_2_i,
   
	//control in AvalonMM
	input logic [COLUMN_WIDTH-1:0] 	conf,
	input logic 					write,
	input logic 					chipselect,
	input logic 					address,

	//data out AvalonST
	output logic [COLUMN_WIDTH-1:0] col_o, 
	output logic 					valid_o,
	input logic 					ready_i,
	output logic 					done_o, 
	output logic 					srt_pck_o,
	output logic 					end_pck_o,

	/* std signals */
	input logic 					clk,
	input logic 					reset_i // reset everything
	);

   //logic [COLUMN_WIDTH-1:0] 		col_ob; //Module out

   logic [COLUMN_WIDTH-1:0] 		col_1; //out from RS1
   logic [COLUMN_WIDTH-1:0] 		col_2; // out from RS2
   
   logic 							ready1; //ready input to first RS
   logic 							ready2; //ready input to second RS

   logic 							valid1; //out from RS1
   logic 							valid2; //out from RS2

   logic 							done1, done2;   

   logic 							was_rdy;
   logic 							input_valid, done_output;
   logic [2:0] 						op;
   logic [31:0] 					constant;
   logic [31:0] 					second_operand;
   
   
   buffer in1(.col_i(col_1_i), 
			  .valid_i(valid_1_i), 
			  .ready_i(ready1),
              .col_o(col_1),
			  .valid_o(valid1),  
			  .ready_o(ready_1_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_1_i),
			  .end_pck_in(end_pck_1_i),
			  .done_i(done_1_i),
			  .done_o(done1)
			  );
   
   buffer in2(.col_i(col_2_i), 
			  .valid_i(valid_2_i), 
			  .ready_i(ready2),
              .col_o(col_2),
			  .valid_o(valid2),  
			  .ready_o(ready_2_o),
			  .clk(clk),
			  .reset_i(reset_i),
			  .start_pck_in(srt_pck_2_i),
			  .end_pck_in(end_pck_2_i),
			  .done_i(done_2_i),
			  .done_o(done2)
			  );

   assign srt_pck_o = 1;
   assign end_pck_o = 1;
   
   always_comb begin
	  
	  if ( op < 3'd4 ) begin
		 input_valid    = valid1 && valid2;
		 done_output    = done1 & done2;
		 second_operand = col_2;
	  end
	  else begin
		 input_valid    = valid1;
		 done_output    = done1;
		 second_operand = constant;
	  end
	  
	  if (was_rdy && input_valid)  begin
		 
		 valid_o = 1;
		 ready1 = 1; 
		 ready2 = 1;   //In case of operation w constant this will drain the stream coming in input2
		 
		 done_o = done_output;
			
		 case(op[1:0])
		   
		   //add
		   2'b00:col_o = $signed(col_1) + $signed(second_operand);
		   //minus
		   2'b01:col_o = $signed(col_1) - $signed(second_operand); 
		   //multiplication
		   2'b10:col_o = $signed(col_1) * $signed(second_operand);
		   // division
		   2'b11:col_o = $signed(col_1) / $signed(second_operand);
		   
		   default: $display("Error in selecting alu operation");
		   
		 endcase
	  end 
	  else begin
		 done_o  = 0;
		 valid_o = 0;
		 col_o   = 0;
		 ready1  = 0;
		 ready2  = 0; 
		 
	  end // else: !if(was_rdy && input_valid)
	  
	  
	  //$display ("ALU COMB time %d was_rdy %b col_1: %d valid1: %b ready1: %b col_2: %d valid2 %b valid_o %b", $time,was_rdy,col_1,valid1,ready1,col_2,valid2,valid_o);
   end


   always_ff @(posedge clk) begin

      if(reset_i) begin
		 op       <= OP; 
		 was_rdy  <= 1'b0;
		 constant <= CONSTANT;
      end
	  else begin
		 if(chipselect && write) begin
			if (address == 0)
			  op <= conf[2:0];
			else
			  constant <= conf;
		 end
		 was_rdy <= ready_i;
	  end
   end

endmodule
