import os
import sys

#should add a third field to map custom interface names to avalon_st names
interfaces = {"data":("[COLUMN_WIDTH-1:0]",False,"data"),
              "valid":("",False,"valid"),
              "ready":("",True,"ready"),
              "error":("",False,"done"),
              "startofpacket":("",False,"srt_pck"),
              "endofpacket":("",False,"end_pck")
              }

def generate_interface_ports( incoming , index):
    ''' generate explicit ports for an interface which could be input or output '''
    ret = ""
    ports = []
    for interface in interfaces:
        width,reverse,custom_name = interfaces[interface]
        port_name = "{0}_{1}".format(("asi_in" if incoming else "aso_out")+str(index),interface)
        port = "{0} logic {1} {2},".format( ( "input" if incoming != reverse else "output") , 
                                                        width,
                                                        port_name
                                               ) 
        ports.append(port)

    return "\n".join(ports)
        
def generate_interface_bindings( incoming, index ):
    interface_name = ("in" if incoming else "out")+"["+str(index-1)+"]"
    #ret = "AvalonLink {0}();\n".format(interface_name)
    bindings = []
    for field in interfaces:
        width,reverse,custom_name = interfaces[field]
        interface_port = "{0}.{1}".format(interface_name,custom_name)
        port_name = "{0}_{1}".format(("asi_in" if incoming else "aso_out")+str(index),field)
        #print interface_port,port_name
        bind = "assign {0} = {1};\n".format( interface_port if incoming != reverse else port_name , port_name if incoming != reverse else interface_port  ) 
        bindings.append(bind)

    return "".join(bindings)

# if sys.argv[3] == "tb":
    
#     for interface,width in interfaces.iteritems():
#         in_port_formatter = lambda x: "{0}_{1}_i".format(interface,x)
#         in_ports = ",".join(map(in_port_formatter,range(1,int(sys.argv[1])+1)))
#         out_port_formatter = lambda x: "{0}_{1}_o".format(interface,x)
#         out_ports = ",".join(map(out_port_formatter,range(1,int(sys.argv[2])+1)))

#         sys.stdout.write( "logic {0} ".format(width) )
#         print "{0};".format(in_ports)
#         sys.stdout.write( "logic {0} ".format(width) )
#         print "{0};".format(out_ports)

# else:
#     for input_index in xrange(1,int(sys.argv[1])+1):
#         for interface,width in interfaces.iteritems():
#             print "input logic {0} {1}_{2}_i,".format(width,interface,input_index)
#         print "\n"
#     for output_index in xrange(1,int(sys.argv[2])+1):
#         for interface,width in interfaces.iteritems():
#             print "output logic {0} {1}_{2}_i,".format(width,interface,output_index)
#         print "\n"

module_ports = ""
interface_assign = ""

assert len(sys.argv) >= 3 , "Usage python make_module.py <number_inputs> <number_outputs>"

for input_index in xrange(1,int(sys.argv[2])+1):
    print generate_interface_ports( True , input_index )
    
for input_index in xrange(1,int(sys.argv[2])+1):
    print generate_interface_ports( False , input_index )

for input_index in xrange(1,int(sys.argv[2])+1):
    print generate_interface_bindings( True , input_index )
    
for input_index in xrange(1,int(sys.argv[2])+1):
    print generate_interface_bindings( False , input_index )
    
