if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

set length 32
set fifo_in1 0x428
set fifo_in2 0x420
set fifo_in3 0x418
set fifo_in4 0x410
set fifo_out1 0x408
set fifo_out2 0x400
set fifo_out3 0x3f8
set fifo_out4 0x3f0
set join_ctrl 0x474

set candidate { 1 2 4 5}
set foreign { 1 1 3 4 4}
set candidate_payload {9 10 11 12}
set foreign_payload {20 21 22 23 24 25}

puts "candidate length: [llength $candidate]"
puts "foreign length: [llength $foreign]"

#specify this is not the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x0
master_write_32 $m [expr $fifo_in2 + 4] 0x0
master_write_32 $m [expr $fifo_in3 + 4] 0x0
master_write_32 $m [expr $fifo_in4 + 4] 0x0

for {set i 0} {$i < [llength $candidate]} {incr i} {
	puts "wrote candidate [lindex $candidate $i]"
	master_write_32 $m $fifo_in1 [lindex $candidate $i]
	master_write_32 $m $fifo_in3 [lindex $candidate_payload $i]
}

for {set i 0} {$i < [llength $foreign]} {incr i} {
	puts "wrote foreign [lindex $foreign $i]"
	master_write_32 $m $fifo_in2 [lindex $foreign $i]
	master_write_32 $m $fifo_in4 [lindex $foreign_payload $i]
}

for {set i 0} {$i < 4} {incr i} {
	set tmp1 [master_read_32 $m $fifo_out1 1]
	master_read_32 $m $fifo_out2 1

	set tmp2 [master_read_32 $m $fifo_out3 1]
	set tmp3 [master_read_32 $m $fifo_out4 1]

	puts "$tmp1 $tmp2 $tmp3"
}

puts "\n******\n"

#specify this is the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x10002
master_write_32 $m [expr $fifo_in2 + 4] 0x10002
master_write_32 $m [expr $fifo_in3 + 4] 0x10002
master_write_32 $m [expr $fifo_in4 + 4] 0x10002

master_write_32 $m $fifo_in1 1000
master_write_32 $m $fifo_in2 1000
master_write_32 $m $fifo_in3 1000
master_write_32 $m $fifo_in4 1000

#clean up done bits
master_read_32 $m $fifo_out1 1
master_read_32 $m $fifo_out2 1
master_read_32 $m $fifo_out3 1
master_read_32 $m $fifo_out4 1
