import subprocess
import sys
import re
import random
import operator
import math
import pdb

#this assumes op is a 2 bit value
#therefore the join is with 4 columns
def join_tile(data,is_foreign_col):
    j = 0

    assert len(data) == 4 and op >= 0 and op < 4
    result = [[] for x in xrange(4)]

    for i,d in enumerate(data[0]):
        while j < len(data[1]) and d > data[1][j]:
            j += 1
        while j < len(data[1]) and d == data[1][j]:
            for k in xrange(len(data)):
                try:
                    result[k].append(data[k][j] if is_foreign_col[k] else data[k][i])
                except:
                    pdb.set_trace()
            j += 1 

    return result
                    
if len(sys.argv) > 1:
    number_of_tests = int(sys.argv[1])
else:
    number_of_tests = 10

random.seed()

#compile all the code
p  = subprocess.Popen("vlog ./my_files/join_tb.sv ./my_files/joiner.sv ./my_files/buffer.sv".split(),stdout = subprocess.PIPE,stderr=subprocess.PIPE)
stdout,stderr = p.communicate()
assert(len(stderr) == 0)
print stdout

for i in xrange(number_of_tests):

    seed            = random.randint(0,1000000)
    send_threshold  = random.randint(0,9)
    ready_threshold = random.randint(0,9)
    incr            = random.randint(1,6) #how much a column can increase
    op              = random.randint(0,3)

    #call modelsim
    cmd           = "vsim -c join_tb -gSEED={0:<8d} -gSEND_THRESHOLD={1} -gREADY_THRESHOLD={2} -gINCR={3} -gOP={4} -do \"run -all\"".format(seed,send_threshold,ready_threshold,incr,op)
    sys.stdout.write( cmd )
    
    p             = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
    stdout,stderr = p.communicate()
    #print stdout
    assert(len(stderr) == 0)

    #check results
    data = [[] for x in xrange(8)]
    for line in stdout.split("\n"):

        if re.match("# TIME",line):
            stuff         = line.split()
            index         = int(stuff[4])
            el            = int(stuff[5])
            data[index-1].append(el)
            #print line

    #process data before passing to the join function
    is_foreign_col = [False,True,op%2==1,op >= 2]
    len_primary = min([ len(x) for x,f in zip(data[:4],is_foreign_col) if not f ])
    len_foreign = min([ len(x) for x,f in zip(data[:4],is_foreign_col) if f ])

    #print len_primary,len_foreign,is_foreign_col
    
    join_input = [ x[:len_foreign] if f else x[:len_primary] for x,f in zip(data[:4],is_foreign_col)]

    # print "INPUT:",join_input
    golden = join_tile(join_input,is_foreign_col)
    # print "GOLDEN:",golden
    result = data[4:]
    # print "RESULT:",result

    assert ( len(golden) == len(result) )
    # now golden can be longer than result since it does not account for the latency of producing a result
    # and the face that every receiver has to be ready at the same time
    len_result = len(result[0]) 
    golden = [ x[:len_result] for x in golden]

    comparison = result == golden
    print ":\t {0:>2}".format(len(result[0])), comparison 
    if not comparison:
        pdb.set_trace()
        # print " ".join(map("{0:<6d}".format,data[0]))
        # print " ".join(map("{0:<6d}".format,data[1]))
        # print " ".join(map("{0:<6d}".format,data[2]))
        # print " ".join(map("{0:<6d}".format,result))
