if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

set bools { 1 1 1 1 1 1 1 1}
set data { 1 2 3 4 5 6 7 8}

set fifo_in1  0x3e8
set fifo_in2  0x3e0
set fifo_out1 0x3d8

#specify this is not the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x0
master_write_32 $m [expr $fifo_in2 + 4] 0x0

for {set i 0} {$i < [llength $bools]} {incr i} {
	master_write_32 $m $fifo_in1 [lindex $bools $i]
}

for {set i 0} {$i < [llength $data]} {incr i} {
	master_write_32 $m $fifo_in2 [lindex $data $i]
}

#specify this is the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x10002
master_write_32 $m [expr $fifo_in2 + 4] 0x10002

master_write_32 $m $fifo_in1 1000
master_write_32 $m $fifo_in2 1000

for {set i 0} {$i < 5} {incr i} {
	set tmp [master_read_32 $m $fifo_out1 1]
	set spec [master_read_32 $m [ expr $fifo_out1 + 4] 1]
	puts "$tmp $spec"
}
