# REQUIRES $m to be an opened valid service master:
if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

# Base addresses of the peripherals: take from Qsys
if { ![info exists fifo0] } {
	set fifo0 0x70
	puts "I had to set fifo0"
}

if { ![info exists fifo2] } {
	set fifo2 0x60
	puts "I had to set fifo2"
}


if { ![info exists length] } {
	set length 4
	puts "I had to set length"
}

for {set i 0} {$i < $length} {incr i} {
	master_write_32 $m [expr $fifo0 +4]  3
	master_write_32 $m $fifo0  $i
	master_write_32 $m [expr $fifo2 +4]  3
	master_write_32 $m $fifo2 $i
}

#now write a single packet with a done
master_write_32 $m [expr $fifo0 +4]  0x10003
master_write_32 $m $fifo0  10
master_write_32 $m [expr $fifo2 +4]  0x10003
master_write_32 $m $fifo2 20