if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

# Base addresses of the peripherals: take from Qsys
if { ![info exists fifo0] } {
	set fifo0 0x70
	puts "I had to set fifo0"
}

if { ![info exists fifo2] } {
	set fifo2 0x60
	puts "I had to set fifo2"
}

if { ![info exists fifo1] } {
	set fifo1 0x68
	puts "I had to set fifo1"
}

# Base addresses of the peripherals: take from Qsys
if { ![info exists fifo0_status] } {
	set fifo0_status 0x40
	puts "I had to set fifo0_status"
}

if { ![info exists fifo1_status] } {
	set fifo1_status 0x20
	puts "I had to set fifo1_status"
}

if { ![info exists fifo2_status] } {
	set fifo2_status 0x0
	puts "I had to set fifo2_status"
}

master_write_32 $m [expr $fifo0 +4]  3
master_write_32 $m $fifo0  68
master_write_32 $m [expr $fifo0 +4]  3
master_write_32 $m $fifo0  95
master_write_32 $m [expr $fifo0 +4]  3
master_write_32 $m $fifo0  26
master_write_32 $m [expr $fifo0 +4]  0x10003
master_write_32 $m $fifo0  61

set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts "After writing all elements in fifo0 -> fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"

master_write_32 $m [expr $fifo2 +4]  3
master_write_32 $m $fifo2  96
master_write_32 $m [expr $fifo2 +4]  3
master_write_32 $m $fifo2  91
set ret [ master_read_32 $m $fifo1 1 ]
set specs [ master_read_32 $m [expr $fifo1 + 4 ] 1 ]
puts "I've read: $ret with specs $specs"

set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts "After writing two elements in fifo2 and reading one -> fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"

master_write_32 $m [expr $fifo2 +4]  3
master_write_32 $m $fifo2  90
set ret [ master_read_32 $m $fifo1 1 ]
set specs [ master_read_32 $m [expr $fifo1 + 4 ] 1 ]
puts "I've read: $ret with specs $specs"
master_write_32 $m [expr $fifo2 +4]  0x10003

set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts " After writing three elements in fifo2 and reading two -> fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"

set ret [ master_read_32 $m $fifo1 1 ]
set specs [ master_read_32 $m [expr $fifo1 + 4 ] 1 ]
puts "I've read: $ret with specs $specs"

set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts "After writing three elements in fifo2 and reading three -> fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"

master_write_32 $m $fifo2  22

set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts "After writing four elements in fifo2 and reading three -> fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"
