# Read the status of two altera fifo

# REQUIRES $m to be an opened valid service master:
if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

# Base addresses of the peripherals: take from Qsys
if { ![info exists fifo0_status] } {
	set fifo0_status 0x40
	puts "I had to set fifo0_status"
}

if { ![info exists fifo1_status] } {
	set fifo1_status 0x20
	puts "I had to set fifo1_status"
}

if { ![info exists fifo2_status] } {
	set fifo2_status 0x0
	puts "I had to set fifo2_status"
}


set f0_count [master_read_32 $m $fifo0_status 1]
set f1_count [master_read_32 $m $fifo1_status 1]
set f2_count [master_read_32 $m $fifo2_status 1]

puts "fifo0: $f0_count fifo1: $f1_count fifo2: $f2_count"



