import subprocess
import sys
import re
import random
import operator
import math
import pdb

if len(sys.argv) > 1:
    number_of_tests = int(sys.argv[1])
else:
    number_of_tests = 10

random.seed()

#div is funny to be the same as in hw
fop = [operator.eq,operator.ne,operator.lt,operator.le,operator.ge,operator.gt]
fop = fop + fop

#compile all the code
p  = subprocess.Popen("vlog ./my_files/boolgen_tb.sv ./my_files/boolgen.sv ./my_files/buffer.sv".split(),stdout = subprocess.PIPE,stderr=subprocess.PIPE)
stdout,stderr = p.communicate()
assert(len(stderr) == 0)
print stdout

for i in xrange(number_of_tests):

    seed            = random.randint(0,1000000)
    send_threshold  = random.randint(0,9)
    ready_threshold = random.randint(0,9)
    op              = random.randint(0,11)
    constant        = random.randint(0,1000)
    
    #call modelsim
    cmd           = "vsim -c boolgen_tb -gSEED={0:<8d} -gSEND_THRESHOLD={1} -gREADY_THRESHOLD={2} -gBOOLGEN_OP={3} -gBOOLGEN_CONSTANT={4:<4} -do \"run -all\"".format(seed,send_threshold,ready_threshold, op if op < 6 else op + 2,constant)
    sys.stdout.write( cmd )

    p             = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
    stdout,stderr = p.communicate()
    assert(len(stderr) == 0)

    #check results
    data = [[],[],[]]
    for line in stdout.split("\n"):

        if re.match("# TIME",line):
            stuff         = line.split()
            index         = int(stuff[4])
            el            = int(stuff[5])
            data[index-1].append(el)
            #print line

    #print data[0],data[1]
    if op < 6:
        result = map(lambda x : fop[op](x[0] , x[1]) , zip(data[0],data[1]))
    else:
        result = map(lambda x : fop[op](x, constant) , data[0])
        
    result = map( lambda x: 1 if x else 0 , result ) #convert bools to ints

    comparison = result[:len(data[2])] == data[2]
    len_diff   = len(result) - len(data[2]) 

    print ":\t {0:>2}".format(len(result)), comparison , len_diff
    if not comparison:
        pdb.set_trace()
        print " ".join(map("{0:<6d}".format,data[0]))
        print " ".join(map("{0:<6d}".format,data[1]))
        print " ".join(map("{0:<6d}".format,data[2]))
        print " ".join(map("{0:<6d}".format,result))
        print fop[op]
