if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

set length 32
set fifo_in1 0x18
set fifo_in2 0x10
set fifo_out1 0x8

set group { 1 1 3 3 6 7 7 8 }
set data  { 1 2 4 5 6 7 8 9 }

#specify this is not the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x0
master_write_32 $m [expr $fifo_in2 + 4] 0x0

for {set i 0} {$i < [llength $group]} {incr i} {
	puts "wrote group [lindex $group $i] data [lindex $data $i]"
	master_write_32 $m $fifo_in1 [lindex $group $i]
	master_write_32 $m $fifo_in2 [lindex $data $i]
}

for {set i 0} {$i < 4} {incr i} {
	set tmp1 [master_read_32 $m $fifo_out1 1]
	set spec [master_read_32 $m [expr $fifo_out1 + 4] 1]
	puts "$tmp1 $spec"
}

puts "\n******\n"

#specify this is the end of the stream
master_write_32 $m [expr $fifo_in1 + 4] 0x10002
master_write_32 $m [expr $fifo_in2 + 4] 0x10002

#does not really matter what group is associated with the done packet
master_write_32 $m $fifo_in1 8 
master_write_32 $m $fifo_in2 10

#clean up last data
set tmp1 [master_read_32 $m $fifo_out1 1]
set spec [master_read_32 $m [expr $fifo_out1 + 4] 1]
puts "$tmp1 $spec"

#clean up done bit
set tmp1 [master_read_32 $m $fifo_out1 1]
set spec [master_read_32 $m [expr $fifo_out1 + 4] 1]
puts "$tmp1 $spec"
