import subprocess
import sys
import re
import random
import operator
import math
from collections import OrderedDict


if len(sys.argv) > 1:
    number_of_tests = int(sys.argv[1])
else:
    number_of_tests = 10

random.seed()


#div is funny to be the same as in hw
fop = [min,max,sum,lambda x : int(float(sum(x))/float(len(x))),len,lambda x : len(set(x)),lambda x : x[0]]

#compile all the code
p  = subprocess.Popen("vlog ./my_files/aggr_tb.sv ./my_files/aggr.sv ./my_files/buffer.sv".split(),stdout= subprocess.PIPE,stderr=subprocess.PIPE)
stdout,stderr = p.communicate()
assert(len(stderr) == 0)
print stdout

for i in xrange(number_of_tests):

    seed            = random.randint(0,1000000)
    send_threshold  = random.randint(0,9)
    ready_threshold = random.randint(0,9)
    op              = random.randint(0,4)
    
    #call modelsim
    cmd           = "vsim -c aggr_tb -gSEED={0:<8d} -gSEND_THRESHOLD={1} -gREADY_THRESHOLD={2} -gAGGR_OP={3} -do \"run -all\"".format(seed,send_threshold,ready_threshold,op)
    sys.stdout.write( cmd )

    p             = subprocess.Popen(cmd,shell=True,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
    stdout,stderr = p.communicate()
    assert(len(stderr) == 0)

    #check results
    data = [[],[],[]]
    for line in stdout.split("\n"):

        if re.match("# TIME",line):
            stuff         = line.split()
            index         = int(stuff[4])
            el            = int(stuff[5])
            data[index-1].append(el)
            #print line

    #print '\n',data[0],'\n',data[1],'\n',data[2]
    aggr = OrderedDict()
    for group,sdata in zip(data[0],data[1]):
        if group in aggr:
            aggr[group].append(sdata)
        else:
            aggr[group] = [sdata]

    for group,sdata in aggr.iteritems():
        aggr[group] = fop[op](sdata)

    result = aggr.values()
    len_diff   = len(result) - len(data[2]) 
    #print result
    #trim the golden result
    result = result[:len(data[2])]
    comparison = result == data[2]

    print ":\t {0:>2}".format(len(result)), comparison , len_diff
    if not comparison:
        print " ".join(map("{0:<6d}".format,data[0]))
        print " ".join(map("{0:<6d}".format,data[1]))
        print " ".join(map("{0:<6d}".format,data[2]))
        print " ".join(map("{0:<6d}".format,result))
