/*
relay station
http://www.cs.columbia.edu/~luca/research/rbilsENTCS06.pdf
 */

/* Working */
module buffer #(
			   parameter COLUMN_WIDTH = 32
			   )

   (
	//data in AvalonST
	input logic [COLUMN_WIDTH-1:0] 	col_i,
	input logic 					valid_i,
	output logic 					ready_o,
	// input logic 					start_pck_in,
	// input logic 					end_pck_in,
	// input logic 					done_i,
   
	//data out AvalonST
	output logic [COLUMN_WIDTH-1:0] col_o,
	output logic 					valid_o,
	input logic 					ready_i,
	// output logic 					start_pck_out,
	// output logic 					end_pck_out,
	// output logic 					done_o, 

	/* std signals */
	input logic 					clk,
	input logic 					reset_i // reset everything
	);

   logic [COLUMN_WIDTH-1:0] 		main;
   logic [COLUMN_WIDTH-1:0] 		aux;

   logic [2:0] 						state;
   logic 							ready;
  
							
   always_comb begin
	  ready_o = ready;
	  col_o = main;
	  case (state)
		0: begin         //EMPTY
		   valid_o = 0;
		   ready_o = 1;  //if I am empty then I am ready
		end
		1: begin         //RUNNING
		  valid_o = 1;
		end
		2: begin
		   valid_o = 1;
		end
		3: begin
		   valid_o = 1;
		end
		4: begin
		   valid_o = 0;
		end
	  endcase
   end 
   
   // assign col_o = (state) ? aux : main;
   // assign valid_o = (state) ? () : ()
   
	 /* input buffering */
   always_ff @(posedge clk) begin
	  if(reset_i) begin
		 $display (" reset! state %d ready: %b ", state,ready);
		 state <= 0;
		 ready <= 1;
	  end
	  else begin
		 ready <= ready_i;
		 case (state)
		   0 : begin           //EMPTY
			 if (valid_i) begin
				main <= col_i;
				if (ready_i) begin
				   state <= 1;
				end
				else begin
				   state <= 2;
				end
			 end
		   end
		   1 : begin           //RUNNING
			 if (valid_i) begin
				main <= col_i;
				if (!ready_i) begin
				   state <= 2;
				end
			 end
			 else begin //~V
				if (ready) begin
				   state <= 0;
				end
			 end
		   end
		   2 : begin           //READY_BLOCK main full - nothing is being read
			  if (valid_i) begin
				aux <= col_i;
				if (ready_i) begin
				   state <= 3;
				end
				else begin
				   state <= 4;
				end
			  end
			  else begin
				 if (ready_i) begin
					state <= 0;
				 end
				 else begin
					state <= 2;
				 end

			  end

		   end
		   3 : begin           //RECOVERY main&aux full but main writable since it is being read
			  if (valid_i) begin
				 main <= aux;
				 aux <= col_i;
				 
				 if (ready_i) begin
					state <= 3;
				 end
				 else begin
					state <= 4;
				 end
			  end
			  else begin
				 main <= aux;
				 if (ready_i) begin
					state <= 1;
				 end
				 else begin
					state <= 2;
				 end

			  end

		   end
		   4 : begin            //STALLING main & aux full - nothing is being read
			  //it has to be not valid
			  if (ready)
				state <= 3;
			  else
				state <= 4;
		   end
		 endcase // case (state)
		 $display (" state %d ready: %b main %d aux %d", state,ready,main,aux);
	  end //!reset
   end    //always_ff
endmodule
