# REQUIRES $m to be an opened valid service master:
if { ![info exists m] } {
	set m [lindex [get_service_paths master] 0]
	open_service master $m
	puts "I had to open the master"
}

# Base addresses of the peripherals: take from Qsys
if { ![info exists fifo0] } {
	set fifo0 0x48
	puts "I had to set fifo0"
}

if { ![info exists fifo1] } {
	set fifo1 0x40
	puts "I had to set fifo1"
}


if { ![info exists length] } {
	set length 10
	puts "I had to set length"
}

for {set i 0} {$i < $length} {incr i} {
	set ret [ master_read_32 $m $fifo1 1 ]
	puts "I've read: $ret"
}