module audio_effects (
    input  clk,
    input  sample_end,
    input  sample_req,
    output [15:0] audio_output,
    input  [15:0] audio_input,
    input  [3:0]  control,
	 
	 input wire        write,            // avalon_slave_0.write
	 input wire        chipselect,  //               .chipselect
	 input wire [3:0]  address,       //               .address
	 input wire reset,
	 input wire [15:0] hex0, hex1, hex2, hex3, hex4, hex5, hex6, hex7
);
//wire [7:0] romdata1;
wire [7:0] romdata_1,romdata_2;
reg [7:0] romdata;
reg [15:0]  index;
reg [15:0] last_sample;
reg [15:0] dat;

assign audio_output = dat;

parameter SINE     = 0;
//////////////////////////////
always @* begin
Audio_display <= 
		(hex1[15:12] == 4'd1||hex1[15:12] == 4'd2||hex1[15:12] == 4'd3||
		hex1[15:12] == 4'd4||hex1[15:12] == 4'd5||hex1[15:12] == 4'd6||
		hex1[15:12] == 4'd7||hex1[15:12] == 4'd8||hex1[15:12] == 4'd9)?//explosion
	8'd1:
		(hex2[14:12]==3'b101||hex4[14:12]==3'b101)?//jump
		/*((hex2[14:12]==3'b010||hex2[14:12]==3'b011||hex2[14:12]==3'b100)||
		(hex4[14:12]==3'b010||hex4[14:12]==3'b011||hex4[14:12]==3'b100))?//walk*/
	8'd2:
		(hex7[3:2]==2'b00||hex7[3:2]==2'b01)?//00 for throw bomb sound of player1 01 for player2
	8'd3:
	8'd0;
end 


bomb1 bomb1 (
	.address(index),
	.clock(clk),
	.q(romdata_1));
bomb2 bomb2 (
	.address(index),
	.clock(clk),
	.q(romdata_2));
explosion explosion (
	.address(index),
	.clock(clk),
	.q(romdata_3));
walk walk (
	.address(index),
	.clock(clk),
	.q(romdata_4));
	
reg [7:0] Audio_display;
///////////////////////////////
reg flag;


	
always @* begin
	//Audio_display = 8'h01;//hex7[15:8];
	//Audio_display = hex ;
	case (Audio_display)
		8'd1 :begin romdata = romdata_3;//explosion
				 flag = 1;
				 end 
		8'd2 :begin romdata = romdata_2;//jump
				 flag = 1;
				 end
		8'd3 :begin romdata = romdata_1;//throw
				 flag = 1;
				 end
				 
		8'd0 :begin romdata = 16'b0;
				  flag = 0;
				  end 
  endcase
end





//////////////////////////////////
always @(posedge clk) begin
		if (reset) index <= 16'd0;
    //if (sample_end) begin
    //    last_sample <= audio_input;
    //end

	 else begin
    if (sample_req) begin
        //if (control[FEEDBACK])
          //  dat <= last_sample;
       // else
		  if (control[SINE]) begin
				if ((index < 16'd65535) && flag)begin
					dat <= {8'd0,romdata};
					index <= index + 16'd1;
				end 
				else begin
					if (flag!=1) 
						index <= 16'd0;
				end
		 
        end 
		  else
				dat <= 16'd0;
	end 
   end	
end


endmodule
