/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [7:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [4:0]  address,
          
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n,
			 output logic [15:0]  hex0_audio, hex1_audio, hex2_audio, hex3_audio,
									hex4_audio, hex5_audio, hex6_audio, hex7_audio);
	
	     //  VGA_LED_Emulator led_emulator(.clk50(clk), .*);		 
			 
			 //internal signal
			 
			logic [23:0] pixel,pixel2,pixel3,pixel4,pixel5,pixel6,pixel7,pixel8,pixel9,pixel10,
							 pixel_pointer_1,
							 pixel_stand1_0,pixel_stand1_1,pixel_stand1_2,pixel_stand1_3,pixel_stand1_4,pixel_stand1_5,pixel_stand1_fail,
							 pixel_stand2_0,pixel_stand2_1,pixel_stand2_2,pixel_stand2_3,pixel_stand2_4,pixel_stand2_5,pixel_stand2_fail,
							 pixel_explosion_1, pixel_explosion_2, pixel_explosion_3, pixel_explosion_4, pixel_explosion_5, 
							 pixel_explosion_6, pixel_explosion_7, pixel_explosion_8, pixel_explosion_9,pixel_explosion_back,
							 pixel_head1, pixel_head2,pixel_greande,pixel_missle,pixel_timer;
							 
			logic	[16:0] addr,addr2,addr3,addr4,addr5,addr6,addr7,addr8,addr_type,
							 addr_pointer_1,			
							 addr_stand1,
							 addr_stand2,
							 addr_explosion,
							 addr_head1,
							 addr_head2;
							 
			logic [7:0] R,G,B,							//soil
							R2,B2,G2,						//stone
							R3,B3,G3,						//grass
							RL01,BL01,GL01,				//background
							RG,BG,GG,						//grenade
							R_stand1,G_stand1,B_stand1,//stand1
							R_stand2,G_stand2,B_stand2,//stand2
							R_pointer_1,G_pointer_1,B_pointer_1,//pointer
							R_explosion, G_explosion, B_explosion, // explosion
							R_head1,G_head1,B_head1,   //head1
							R_head2,G_head2,B_head2,   //head2
							R_type,G_type,B_type;
							
			logic [10:0] hcount;
			logic [9:0] vcount;
			logic [15:0] hex0, hex1, hex2, hex3, hex4, hex5, hex6, hex7, hex8, hex9, hex10, 
							 hex11, hex12, hex13, hex14, hex15;
			assign hex0_audio = hex0;
			assign hex1_audio = hex1;
			assign hex2_audio = hex2;
			assign hex3_audio = hex3;
			assign hex4_audio = hex4;
			assign hex5_audio = hex5;
			assign hex6_audio = hex6;
			assign hex7_audio = hex7;
			
			 
			danenge soil	(.clock(clk), .address(addr), .q(pixel));
			stone stone		(.clock(clk), .address(addr2), .q(pixel2));
			grass grass		(.clock(clk), .address(addr3), .q(pixel3));
			left01 left01	(.clock(clk), .address(addr4), .q(pixel4));
			greande greande(.clock(clk), .address(addr5), .q(pixel5));
			missle missle(.clock(clk), .address(addr5), .q(pixel9));
			timer timer(.clock(clk), .address(addr5), .q(pixel10));
			
			greande greande_tpye(.clock(clk), .address(addr_type), .q(pixel_greande));
			missle missle_type(.clock(clk), .address(addr_type), .q(pixel_missle));
			timer timer_type(.clock(clk), .address(addr_type), .q(pixel_timer));
			
			pointer pointer_1(.clock(clk), .address(addr_pointer_1), .q(pixel_pointer_1));
			stand1 stand1_0(.clock(clk), .address(addr_stand1), .q(pixel_stand1_0));
			stand1_1 stand1_1(.clock(clk), .address(addr_stand1), .q(pixel_stand1_1));
			stand1_2 stand1_2(.clock(clk), .address(addr_stand1), .q(pixel_stand1_2));
			stand1_3 stand1_3(.clock(clk), .address(addr_stand1), .q(pixel_stand1_3));
			stand1_4 stand1_4(.clock(clk), .address(addr_stand1), .q(pixel_stand1_4));
			stand1_5 stand1_5(.clock(clk), .address(addr_stand1), .q(pixel_stand1_5));
			stand1_fail stand1_fail(.clock(clk), .address(addr_stand1), .q(pixel_stand1_fail));
			
			stand2 stand2_0(.clock(clk), .address(addr_stand2), .q(pixel_stand2_0));
			stand2_1 stand2_1(.clock(clk), .address(addr_stand2), .q(pixel_stand2_1));
			stand2_2 stand2_2(.clock(clk), .address(addr_stand2), .q(pixel_stand2_2));
			stand2_3 stand2_3(.clock(clk), .address(addr_stand2), .q(pixel_stand2_3));
			stand2_4 stand2_4(.clock(clk), .address(addr_stand2), .q(pixel_stand2_4));
			stand2_5 stand2_5(.clock(clk), .address(addr_stand2), .q(pixel_stand2_5));
			stand2_fail stand2_fail(.clock(clk), .address(addr_stand2), .q(pixel_stand2_fail));
			
			explosion_1 explosion_1(.clock(clk), .address(addr_explosion), .q(pixel_explosion_1));
			explosion_2 explosion_2(.clock(clk), .address(addr_explosion), .q(pixel_explosion_2));
			explosion_3 explosion_3(.clock(clk), .address(addr_explosion), .q(pixel_explosion_3));
			explosion_4 explosion_4(.clock(clk), .address(addr_explosion), .q(pixel_explosion_4));
			explosion_5 explosion_5(.clock(clk), .address(addr_explosion), .q(pixel_explosion_5));
			explosion_6 explosion_6(.clock(clk), .address(addr_explosion), .q(pixel_explosion_6));
			explosion_7 explosion_7(.clock(clk), .address(addr_explosion), .q(pixel_explosion_7));
			explosion_8 explosion_8(.clock(clk), .address(addr_explosion), .q(pixel_explosion_8));
			explosion_9 explosion_9(.clock(clk), .address(addr_explosion), .q(pixel_explosion_9));
			explosion_back explosion_back(.clock(clk), .address(addr_explosion), .q(pixel_explosion_back));
			
			head_p1 head_p1(.clock(clk), .address(addr_head1), .q(pixel_head1));
			head_p2 head_p2(.clock(clk), .address(addr_head2), .q(pixel_head2));
		
	
			ROMdecoder_stand1 stand1_de(.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_stand1), .Goutput(G_stand1), .Boutput(B_stand1), 
												.ROMdata_0(pixel_stand1_0),
												.ROMdata_1(pixel_stand1_1),
												.ROMdata_2(pixel_stand1_2),
												.ROMdata_3(pixel_stand1_3),
												.ROMdata_4(pixel_stand1_4),
												.ROMdata_5(pixel_stand1_5),
												.ROMdata_6(pixel_stand1_fail),												
												.addr(addr_stand1),
												.hexv(hex2), .hexh(hex3)); 
	
			ROMdecoder_stand2 stand2_de(.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_stand2), .Goutput(G_stand2), .Boutput(B_stand2), 
												.ROMdata_0(pixel_stand2_0),
												.ROMdata_1(pixel_stand2_1),
												.ROMdata_2(pixel_stand2_2),
												.ROMdata_3(pixel_stand2_3),
												.ROMdata_4(pixel_stand2_4),
												.ROMdata_5(pixel_stand2_5),
											   .ROMdata_6(pixel_stand2_fail),	
												.addr(addr_stand2),
												.hexv(hex4), .hexh(hex5));  
													
			ROMdecoder_pointer ROMdecoder_pointer1(.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_pointer_1), .Goutput(G_pointer_1), .Boutput(B_pointer_1), 
												.ROMdata(pixel_pointer_1),
												.hex2(hex2), .hex3(hex3), .hex4(hex4), .hex5(hex5), .hex6(hex6),
												.addr(addr_pointer_1));  
												
			ROMdecoder_explosion ROMdecoder_explosion_de(.clk(clk),
												.hcount(hcount), .vcount(vcount),
												.Routput(R_explosion), .Goutput(G_explosion), .Boutput(B_explosion),
												.ROMdata_1(pixel_explosion_1),
												.ROMdata_2(pixel_explosion_2),
												.ROMdata_3(pixel_explosion_3),
												.ROMdata_4(pixel_explosion_4),
												.ROMdata_5(pixel_explosion_5),
												.ROMdata_6(pixel_explosion_6),
												.ROMdata_7(pixel_explosion_7),
												.ROMdata_8(pixel_explosion_8),
												.ROMdata_9(pixel_explosion_9),
												.addr(addr_explosion),
												.hexv(hex0),.hexh(hex1));								 									
												
			ROMdecoder soil_de(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R), .Goutput(G), .Boutput(B), 
												.ROMdata(pixel),
												.addr(addr));  
											 
			ROMdecoder stone_de(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R2), .Goutput(G2), .Boutput(B2), 
												.ROMdata(pixel2),
												.addr(addr2));
											 
			ROMdecoder grass_de(			.clk(clk),
												.hcount(hcount), .vcount(vcount),
												.Routput(R3), .Goutput(G3), .Boutput(B3), 
												.ROMdata(pixel3),
												.addr(addr3));
											 
			ROMdecoder_left left01_de(	.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(RL01), .Goutput(GL01), .Boutput(BL01), 
												.ROMdata(pixel4),
												.addr(addr4));
	
			ROMdecoder2 grenade(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(RG), .Goutput(GG), .Boutput(BG), 
												.ROMdata_G(pixel5),
												.ROMdata_M(pixel9),
												.ROMdata_T(pixel10),
												.addr(addr5), 
												.hexv(hex0), .hexh(hex1));	
			
			ROMdecoder_head1 head1_de(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_head1), .Goutput(G_head1), .Boutput(B_head1), 
												.ROMdata(pixel_head1),
												.addr(addr_head1));  
												
		   ROMdecoder_head2 head2_de(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_head2), .Goutput(G_head2), .Boutput(B_head2), 
												.ROMdata(pixel_head2),
												.addr(addr_head2));  
												
			ROMdecoder3 grenade_type(			.clk(clk), 
												.hcount(hcount), .vcount(vcount),
												.Routput(R_type), .Goutput(G_type), .Boutput(B_type), 
												.ROMdata_G(pixel_greande),
												.ROMdata_M(pixel_missle),
												.ROMdata_T(pixel_timer),
												.addr(addr_type), 
												.hexv(hex0), .hexh(hex1));
			
			
			VGA_LED_Emulator led_emulator(.clk50(clk),
													.in_R(R), .in_G(G), .in_B(B),
													.in_R_pointer(R_pointer_1), .in_G_pointer(G_pointer_1), .in_B_pointer(B_pointer_1),
													.in_R2(R2), .in_G2(G2), .in_B2(B2),
													.in_R3(R3), .in_G3(G3), .in_B3(B3),
													.in_RL01(RL01), .in_GL01(GL01), .in_BL01(BL01),
													.in_RG(RG), .in_GG(GG), .in_BG(BG),
													.in_R_stand1(R_stand1), .in_G_stand1(G_stand1), .in_B_stand1(B_stand1),
													.in_R_stand2(R_stand2), .in_G_stand2(G_stand2), .in_B_stand2(B_stand2),
													.in_R_explosion(R_explosion), .in_G_explosion(G_explosion), .in_B_explosion(B_explosion),
													.in_R_head1(R_head1), .in_G_head1(G_head1), .in_B_head1(B_head1),
													.in_R_head2(R_head2), .in_G_head2(G_head2), .in_B_head2(B_head2),
													//.in_R_type(R_type), .in_G_type(G_type), .in_B_type(B_type),
													.hex0(hex0), .hex1(hex1), .hex2(hex2), .hex3(hex3), .hex4(hex4), .hex5(hex5), .hex6(hex6), .hex7(hex7),
													.hex8(hex8), .hex9(hex9), .hex10(hex10), .hex11(hex11), .hex12(hex12), .hex13(hex13), .hex14(hex14), .hex15(hex15),
													.hcount(hcount), .vcount(vcount), .*);
		
		
	  always_ff @(posedge clk)
     if (reset) begin
     
    hex0 <= {6'b000000,10'd329};//b00000000; // 
    hex1 <= {4'd4,4'd0,8'd200};//b00000000; // 
	 hex2 <= 16'b0110000000000000;//b00000000; // 
    hex3 <= {8'b01101000,8'd250};//b00000000; // 
    hex4 <= 16'b0110000000000000;//b00000000; // 
    hex5 <= {8'b00111100,8'd350};//b00000000; // 
    hex6 <= 16'b0101111111011111;//b00000000; // 
    hex7 <= 16'b1001001011000000;//b00000000; // 
	 hex8 <= {6'b000000,10'd329};//b00000000; // 
    hex9 <= {6'd10,6'd40};//b00000000; // 
	 hex10 <= 8'd200+16'ha000;//b00000000; // 
    hex11 <= 8'd250;//b00000000; // 
    hex12 <= 8'd200;//b00000000; // 
    hex13 <= 8'd350;//b00000000; // 
    hex14 <= 16'b0111111111000000;//b00000000; // 
    hex15 <= 8'd000;//b00000000; // 
     end else if (chipselect && write)
       case (address)
     5'h0 : hex0[7:0] <= writedata;
	  5'h1 : hex0[15:8] <= writedata;
     5'h2 : hex1[7:0] <= writedata;
	  5'h3 : hex1[15:8] <= writedata;
     5'h4 : hex2[7:0] <= writedata;
	  5'h5 : hex2[15:8] <= writedata;
     5'h6 : hex3[7:0] <= writedata;
	  5'h7 : hex3[15:8]<= writedata;
     5'h8 : hex4[7:0] <= writedata;
	  5'h9 : hex4[15:8]<= writedata;
     5'ha : hex5[7:0] <= writedata;
	  5'hb : hex5[15:8]<= writedata;
     5'hc : hex6[7:0] <= writedata;
	  5'hd : hex6[15:8]<= writedata;
     5'he : hex7[7:0] <= writedata;
	  5'hf : hex7[15:8] <= writedata;
	  5'h10 : hex8[7:0] <= writedata;
	  5'h11 : hex8[15:8] <= writedata;
     5'h12 : hex9[7:0] <= writedata;
	  5'h13 : hex9[15:8] <= writedata;
     5'h14 : hex10[7:0] <= writedata;
	  5'h15 : hex10[15:8] <= writedata;
     5'h16 : hex11[7:0] <= writedata;
	  5'h17 : hex11[15:8]<= writedata;
     5'h18 : hex12[7:0] <= writedata;
	  5'h19 : hex12[15:8]<= writedata;
     5'h1a : hex13[7:0] <= writedata;
	  5'h1b : hex13[15:8]<= writedata;
     5'h1c : hex14[7:0] <= writedata;
	  5'h1d : hex14[15:8]<= writedata;
     5'h1e : hex15[7:0] <= writedata;
	  5'h1f : hex15[15:8] <= writedata;
	  
       endcase		  
   /*always_ff @(posedge clk)
     if (reset) begin
	CenterballX <= 10'd20; // 20 pixels
	CenterballY <= 10'd20;
     end else if (chipselect && write)
       case (address)
	 3'h0 : CenterballX <= writedata[9:0];
	 3'h2 : CenterballY <= writedata[9:0];
	 default: CenterballX <= writedata[9:0];
       endcase*/
		
endmodule