module audio_top (
    input  OSC_50_B8A,

    inout  AUD_ADCLRCK,
    input  AUD_ADCDAT,
    inout  AUD_DACLRCK,
    output AUD_DACDAT,
    output AUD_XCK,
    inout  AUD_BCLK,
    output AUD_I2C_SCLK,
    inout  AUD_I2C_SDAT,
    output AUD_MUTE,

    input  [3:0] KEY,
    input  [3:0] SW,
    output [3:0] LED,
	 
	 input wire        write,            // avalon_slave_0.write
	 input wire        chipselect,       //               .chipselect
	 input wire [3:0]  address,          //               .address
		input wire [15:0] hex0_audio, 
		input wire [15:0] hex1_audio,
		input wire [15:0] hex2_audio, 
		input wire [15:0] hex3_audio,
		input wire [15:0] hex4_audio, 
		input wire [15:0] hex5_audio,
		input wire [15:0] hex6_audio, 
		input wire [15:0] hex7_audio
);

wire reset = !KEY[0];
wire main_clk;
wire audio_clk;

wire [1:0] sample_end;
wire [1:0] sample_req;
wire [15:0] audio_output;
wire [15:0] audio_input;
wire [15:0] hex0, hex1, hex2, hex3, hex4, hex5, hex6, hex7;
			assign hex0 = hex0_audio;
			assign hex1 = hex1_audio;
			assign hex2 = hex2_audio;
			assign hex3 = hex3_audio;
			assign hex4 = hex4_audio;
			assign hex5 = hex5_audio;
			assign hex6 = hex6_audio;
			assign hex7 = hex7_audio;
			

PLL clock_pll (
    .refclk (OSC_50_B8A),
    .rst (reset),
    .outclk_0 (audio_clk),
    .outclk_1 (main_clk)
);

i2c_av_config av_config (
    .clk (main_clk),
    .reset (reset),
    .i2c_sclk (AUD_I2C_SCLK),
    .i2c_sdat (AUD_I2C_SDAT),
    .status (LED)
);

assign AUD_XCK = audio_clk;
assign AUD_MUTE = (SW != 4'b0);

audio_codec ac (
    .clk (audio_clk),
    .reset (reset),
    .sample_end (sample_end),
    .sample_req (sample_req),
    .audio_output (audio_output),
    .audio_input (audio_input),
    .channel_sel (2'b10),

    .AUD_ADCLRCK (AUD_ADCLRCK),
    .AUD_ADCDAT (AUD_ADCDAT),
    .AUD_DACLRCK (AUD_DACLRCK),
    .AUD_DACDAT (AUD_DACDAT),
    .AUD_BCLK (AUD_BCLK)
);

audio_effects sound (
    .clk (audio_clk),
    .sample_end (sample_end[1]),
    .sample_req (sample_req[1]),
    .audio_output (audio_output),
    .audio_input  (audio_input),
    .control (SW),
	 .write (write),            // avalon_slave_0.write
	 .chipselect (chipselect),  //               .chipselect
	 .address (address),       //               .address
	 .reset (reset),
	 .hex0	 (hex0_audio), 
				.hex1	 (hex1_audio),
				.hex2	 (hex2_audio),
				.hex3	 (hex3_audio),
				.hex4	 (hex4_audio), 
				.hex5  (hex5_audio), 
				.hex6	 (hex6_audio), 
				.hex7	 (hex7_audio)
	 
);

endmodule
